Name: daemontools
Version: 0.76
Release: alt13
Summary: Daemontools by DJB
License: Public domain
Group: System/Servers
Url: http://cr.yp.to/

Packager: Denis Smirnov <mithraen@altlinux.ru>

Source: %name-%version.tar
Source1: %name.rpm.macro
Source2: %name.service

Patch: %name-%version.command.patch
Patch1: %name.errno.patch
Patch2: %name.check.setgroup.patch
Patch3: %name.warnings.patch

Requires(pre): startup
Requires(post): daemontools-common = %version-%release

%description
Daemontools by DJB

%package common
Group: System/Base
Summary: Daemontools and other packages shared files
Conflicts: %name < %version-%release
Requires: rpm-macros-%name = %version-%release
BuildArch: noarch

%description common
Daemontools and other packages shared files

%package -n rpm-macros-%name
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other
# helps old apt to resolve file conflict at dist-upgrade (thanks to Stanislav Ievlev)
Conflicts: daemontools-common <= 0.76-alt7
BuildArch: noarch

%description -n rpm-macros-%name
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%prep
%setup -c
%patch -p1
%patch1 -p1
%patch2 -p0
%patch3 -p1

%build
pushd admin/%name-%version
package/compile
popd

%install
mkdir -p %buildroot/bin %buildroot%_sysconfdir/daemontools.d

cp -a admin/%name-%version/command/* %buildroot/bin/
install -D -m644 %SOURCE1 %buildroot%_rpmmacrosdir/%name
install -D -m644 %SOURCE2 %buildroot/lib/systemd/system/%name.service

%post
if grep svscanboot %_sysconfdir/inittab >/dev/null
then
  echo 'inittab contains an svscanboot line. I assume that svscan is already running.'
else
  echo 'Adding svscanboot to inittab...'
  rm -f %_sysconfdir/inittab'{new}'

  cat %_sysconfdir/inittab > %_sysconfdir/inittab'{new}'
  echo >>  %_sysconfdir/inittab'{new}'
  echo 'SV:123456:respawn:/bin/svscanboot' >> %_sysconfdir/inittab'{new}'
  mv -f %_sysconfdir/inittab'{new}' %_sysconfdir/inittab
  kill -HUP 1
  echo 'init should start svscan now.'
fi
if [ ! -f %_sysconfdir/daemontools.d/.gitignore ]; then
	echo supervise > %_sysconfdir/daemontools.d/.gitignore
fi

# systemd support
systemctl=/bin/systemctl
if [ -f "$systemctl" ]; then
    $systemctl enable daemontools.service ||:
    $systemctl start daemontools.service ||:
fi


%files
/bin/envdir
/bin/envuidgid
/bin/fghack
/bin/multilog
/bin/pgrphack
/bin/readproctitle
/bin/setlock
/bin/setuidgid
/bin/softlimit
/bin/supervise
/bin/svc
/bin/svok
/bin/svscan
/bin/svscanboot
/bin/svstat
/bin/tai64n
/bin/tai64nlocal
/lib/systemd/system/%name.service

%files common
%dir %_sysconfdir/daemontools.d

%files -n rpm-macros-%name
%_rpmmacrosdir/%name

%changelog
