Name: dansguardian
Version: 2.10.1.1
Release: alt3.1.qa1

Summary: Content filter
Summary(ru_RU.UTF-8): Фильтр WEB-содержимого
License: GPLv2
Url: http://www.dansguardian.org
Group: System/Servers
Packager: Avramenko Andrew <liks at altlinux.ru>

Source0: %name-%version.tar
Patch1: %name-%version-%release.patch
Patch2: %name-lists-2.9.8.1.patch
Patch3: %name-2.10.1.1-alt-gcc4.6.patch

BuildRequires: gcc-c++ libpcre-devel zlib-devel

%description
DansGuardian is a web content filtering proxy that uses Squid to do all the fetching.
It filters using multiple methods. These methods include URL and domain filtering,
content phrase filtering, PICS filtering, MIME filtering, file extension filtering,
POST limiting.

%description -l ru_RU.UTF-8
DansGuardian - фильтр WEB содержимого, который использует Squid для получения данных.
Предусмотрена возможность фильтрации несколькими методами. Эти методы включают фильтрацию
по URL и имени домена, по фразам, по картинкам, по типам MIME, по расширению файлов, ограничение
метода POST.

%prep
%setup -q
%patch1 -p1
%patch2
%patch3 -p2

%build
%autoreconf
%configure  --enable-clamd \
	    --enable-ntlm \
	    --with-logdir=/var/log/%name \
	    --with-proxyuser=%name \
	    --with-proxygroup=%name \
	    --with-piddir=/var/run \
#	    --with-dgdebug

%make_build

%install
make install DESTDIR=%buildroot
cd data/languages; %make_install; cd ../..
mkdir -p %buildroot%_logdir/%name
mkdir -p %buildroot%_initdir
mkdir -p %buildroot/var/run/%name
mkdir -p %buildroot%_sysconfdir/logrotate.d
install -p -m 0755 data/scripts/systemv-init %buildroot%_initdir/%name
install -p data/scripts/%name %buildroot%_sysconfdir/logrotate.d/
rm -rf %buildroot/usr/share/doc/%name

%pre
%_sbindir/groupadd -r -f %name >/dev/null 2>&1
%_sbindir/useradd -r -n -g %name -d /dev/null -s /dev/null %name >/dev/null 2>&1 ||:

%preun
%preun_service %name

%post
%post_service %name

%files
%config(noreplace) %_sysconfdir/%name/*
%doc INSTALL AUTHORS README NEWS COPYING doc/AuthPlugins doc/ContentScanners doc/DownloadManagers doc/FAQ doc/FAQ.html doc/Plugins
%_sbindir/*
%_datadir/%name/*
%_man8dir/*
%attr(2770,root,%name) %dir %_logdir/%name
%attr(755,root,root) %_initdir/*
%attr(644,root,root) %_sysconfdir/logrotate.d/*
%attr(2775,root,%name) /var/run/%name

%changelog
