# handle initscript style change (c) mike@ :)
Name: dante
Version: 1.2.2
Release: alt2.qa1

%define service sockd
%define srcname %name-%version

Summary: A free Socks v4/v5 client/server implementation
Summary(RU_ru.KOI8-R):    socks (v4/v5)
License: BSD-type
Group: Networking/Other
Url: http://www.inet.no/%name/

Packager: Timur Aitov <timonbl4@altlinux.org>

Source: ftp://ftp.inet.no/pub/socks/%srcname.tar.gz

Source1: sockd.init

Patch0: %name-1.2.2-alt-libdl.patch
Patch1: %name-1.2.2-alt-pidfile.patch
Patch2: %name-1.2.2-alt-sockd.conf.patch

Requires: lib%name = %version-%release

# Automatically added by buildreq on Thu Feb 12 2004
BuildRequires: bison flex libpam-devel libwrap-devel
BuildRequires: altlinux-release

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

%package -n lib%name
Summary: A free Socks v4/v5 client implementation
Summary(RU_ru.KOI8-R):  Socks v4/v5
Group: System/Libraries
Provides: libsocks

%package -n lib%name-devel
Summary: Development environment for socks
Summary(RU_ru.KOI8-R):       socks
Group: Development/C
Requires: lib%name = %version-%release

%package -n lib%name-devel-static
Summary: Static libraries for socks
Summary(RU_ru.KOI8-R):     socks .
Group: Development/C
Requires: lib%name-devel = %version-%release

%package server
Summary: A free Socks v4/v5 server implementation
Summary(RU_ru.KOI8-R): Socks v4/v5 -.
Group: System/Servers

Requires(post,preun): service, chkconfig
Requires: %name = %version-%release libpam libwrap
Provides: %service

%description
Dante is a free implementation of the proxy protocols socks version 4,
socks version 5 (rfc1928) and msproxy. It can be used as a firewall
between networks. It is being developed by Inferno Nettverk A/S, a
Norwegian consulting company. Commercial support is available.

This package contains utilities and documentation required to
"socksify" existing applications to become socks clients.

%description -l ru_RU.KOI8-R
Dante -     socks 
4  5 (rfc1928)  msproxy.    
       TCP/UDP.
Dante     Inferno Nettverk A/S,
      dante.

       
     socks (""
/"socksify"/).

%description -n lib%name
This package contains the dynamic libraries required to "socksify"
existing applications to become socks clients.

%description -l ru_RU.KOI8-R
     ""
.

%description -n lib%name-devel
This package contains libraries and header files required to compile
programs that use socks.

%description -l ru_RU.KOI8-R
       
socks.

%description -n lib%name-devel-static
This package contains static libraries required to build statically linked
programs that use socks.

%description -l ru_RU.KOI8-R
      socks.

%description server
This package contains the socks proxy daemon and its documentation.
The sockd is the server part of the Dante socks proxy package and
allows socks clients to connect through it to the network.

%description -l ru_RU.KOI8-R
Socks      .   Dante -
'sockd'.

%prep
%setup -q -n %srcname

%patch0 -p2
%patch1 -p2
%patch2 -p2

%build
echo >> acinclude.m4
%autoreconf
%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
%configure %{subst_enable static}

%make_build

%install
%makeinstall

# Set library as executable - prevent ldd from complaining
chmod 755 %buildroot%_libdir/*.so*
install -pD -m644 example/socks-simple.conf %buildroot%_sysconfdir/socks.conf
install -p  -m644 example/%service.conf     %buildroot%_sysconfdir
install -pD -m755 %SOURCE1                  %buildroot%_initdir/%service

pushd %buildroot%_libdir
	ln -s libsocks.so.*.*.* libsocks5.so
popd

mkdir -p       %buildroot%_sysconfdir/sysconfig
cat << _EOF_  >%buildroot%_sysconfdir/sysconfig/%service
# Socks proxy daemon command line options
EXTRAOPTIONS="-D"
_EOF_

%pre server
%_sbindir/groupadd -r -f %service &> /dev/null ||:
%_sbindir/useradd  -r -g %service -d /dev/null \
                   -s /dev/null -n %service &> /dev/null ||:
%_sbindir/useradd  -r -g %service -d /dev/null \
                   -s /dev/null -n no%service &> /dev/null ||:

%post server
%post_service %service

%preun server
%preun_service %service
%files -n lib%name
%_libdir/*.so.*
%_libdir/libdsocks.so

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files
%_bindir/socksify
%_man1dir/*
%_man5dir/socks.conf.*
%config(noreplace) %_sysconfdir/socks.conf
%doc               BUGS CREDITS INSTALL LICENSE NEWS README SUPPORT TODO
%doc               doc/README* doc/rfc* doc/SOCKS4.protocol example/*.conf
%doc               doc/module/*.tex  contrib/sockd-stat.awk

%files server
%_sbindir/*
%_man8dir/*
%_man5dir/%service.conf.*
%config(noreplace) %_sysconfdir/sysconfig/%service
%config(noreplace) %_sysconfdir/%service.conf
%config(noreplace) %_initdir/%service

%changelog
