%def_enable shared
%def_enable static

Name: dapl2
%define lname lib%name
%define oldlname libdapl
Version: 2.0.30
Release: alt2.1
Summary: A Library for userspace access to RDMA devices using OS Agnostic DAT APIs
Group: System/Libraries
License: %gpl2only, %bsdstyle, CPL
Url: http://www.openfabrics.org/
# git://git.openfabrics.org/~ardavis/dapl.git
Source: %name-%version.tar.gz
Patch: dapl2-2.0.30-alt-glibc-2.16.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires: librdmacm-devel

%description
Along with the OpenFabrics kernel drivers, libdat and libdapl provides
a userspace RDMA API that supports DAT 2.0 specification and IB
transport extensions for atomic operations and rdma write with
immediate data.


%package -n %lname
Summary: A Library for userspace access to RDMA devices using OS Agnostic DAT APIs
Group: System/Libraries

%description -n %lname
Along with the OpenFabrics kernel drivers, libdat and libdapl provides
a userspace RDMA API that supports DAT 2.0 specification and IB
transport extensions for atomic operations and rdma write with
immediate data.


%package -n %lname-devel
Summary: Development files for the libdat and libdapl libraries
Group: Development/C
Requires: %lname = %version-%release
Conflicts: %oldlname-devel

%description -n %lname-devel
Header files for libdat and libdapl library.


%package -n %lname-devel-static
Summary: Static development files for libdat and libdapl library
Group: Development/C
Requires: %lname-devel = %version-%release
Conflicts: %oldlname-devel-static

%description -n %lname-devel-static
Static libraries for libdat and libdapl library.


%package utils
Summary: Test suites for uDAPL library
Group: Development/Other
Requires: %lname = %version-%release
Conflicts: %oldlname-utils

%description utils
Useful test suites to validate uDAPL library API's.


%prep
%setup
%patch -p1


%build
%autoreconf
%configure \
    --with-pic \
    %{subst_enable shared} \
    %{subst_enable static} \
    --with-gnu-ld \
    --enable-ext-type=ib
%make_build


%install
%make_install DESTDIR=%buildroot install{-datlibLTLIBRARIES,}

mv %buildroot%_sysconfdir/dat.conf \
	%buildroot%_sysconfdir/dat2.conf

%files -n %lname
%doc AUTHORS README ChangeLog
%_libdir/*.so.*
%config(noreplace) %_sysconfdir/dat2.conf


%files -n %lname-devel
%_libdir/*.so
%_includedir/dat2


#files -n %lname-devel-static
#_libdir/*.a


%files utils
%_bindir/*
%_man1dir/*
%_man5dir/*


%changelog
