%define ver_major 2.6
%define beta %nil

Name: darktable
Version: %ver_major.0
Release: alt1

Summary: Darktable is a virtual lighttable and darkroom for photographer
License: GPLv3
Group: Graphics

Url: http://%name.org/
#VCS: https://github.com/darktable-org/darktable.git
#Source: %name-%version.tar
Source: https://github.com/darktable-org/darktable/releases/download/release-%version/%name-%version.tar.xz

%define cmake_ver 3.4
%define glib_ver 2.40
%define gtk_ver 3.14
%define exiv2_ver 0.24
%define iso_codes_ver 3.66

Requires: iso-codes >= %iso_codes_ver
Requires: icon-theme-adwaita

BuildRequires(pre): cmake >= %cmake_ver
BuildRequires: gcc-c++ libgomp-devel
BuildRequires: /proc
BuildRequires: intltool desktop-file-utils libappstream-glib-devel
BuildRequires: perl-Pod-Parser xsltproc
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libxml2-devel
BuildRequires: libSDL2-devel libX11-devel libXrandr-devel libcurl-devel
BuildRequires: libexiv2-devel >= %exiv2_ver libflickcurl-devel libsecret-devel
BuildRequires: libgphoto2-devel libjpeg-devel liblcms2-devel liblensfun-devel
BuildRequires: libpng-devel librsvg-devel libsqlite3-devel libtiff-devel
BuildRequires: openexr-devel libxkbcommon-x11-devel lsb-release
BuildRequires: libjson-glib-devel libsoup-devel libpixman-devel libexpat-devel
BuildRequires: libcolord-gtk-devel libudev-devel
BuildRequires: libGraphicsMagick-c++-devel libopenjpeg2.0-devel
BuildRequires: libharfbuzz-devel libwebp-devel libxshmfence-devel
# since 2.0
BuildRequires: libpugixml-devel libcups-devel
BuildRequires: libosm-gps-map1.0-devel
BuildRequires: python-module-jsonschema
BuildRequires: iso-codes-devel >= %iso_codes_ver
# for build from git tree
#BuildRequires: gnome-doc-utils fop saxon ...

%description
darktable is a virtual light table and darkroom for photographers. It manages
your digital negatives in a database and lets you view them through a zoomable
light table. It also enables you to develop raw images and enhance them.

%prep
%setup -n %name-%version

%build
%cmake -DCMAKE_SKIP_RPATH:BOOL=OFF \
-DCMAKE_BUILD_TYPE=Release \
-DBINARY_PACKAGE_BUILD:BOOL=ON
%cmake_build VERBOSE=1
%install
%cmakeinstall_std

ln -s %name/lib%name.so %buildroot%_libdir/lib%name.so

install -pD -m644 data/pixmaps/16x16/darktable.png %buildroot%_miconsdir/darktable.png
install -pD -m644 data/pixmaps/32x32/darktable.png %buildroot%_niconsdir/darktable.png
install -pD -m644 data/pixmaps/48x48/darktable.png %buildroot%_liconsdir/darktable.png

%find_lang %name

%files -f %name.lang
%_bindir/*
%_datadir/%name/
%_libdir/lib%name.so
%_libdir/%name/
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*
%_man1dir/*
%_datadir/appdata/%name.appdata.xml
%exclude /usr/share/doc/%name/

%changelog
