%def_disable snapshot

%define _unpackaged_files_terminate_build 1
%define ver_major 3.24
%define _name ca.desrt.dconf-editor

Name: dconf-editor
Version: %ver_major.3
Release: alt0.M80P.1

Summary: dconf confuguration editor
Group: Graphical desktop/GNOME
License: GPLv3
Url: https://wiki.gnome.org/Projects/dconf

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define gtk_ver 3.21.6
%define dconf_ver 0.26
%define vala_ver 0.33.1

Requires: dconf >= %dconf_ver

BuildPreReq: libgtk+3-devel >= %gtk_ver libdconf-devel >= %dconf_ver
BuildPreReq: vala-tools >= %vala_ver
BuildRequires: libxml2-devel rpm-build-gnome gnome-common
BuildRequires: intltool libappstream-glib-devel yelp-tools
%{?_enable_snapshot:BuildRequires: libdconf-vala}

%description
dconf is a low-level configuration system. Its main purpose is to
provide a backend to GSettings API in Glib for storing and retrieving
application settings.

This package provides graphical dconf configuration editor.


%prep
%setup
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang %name dconf

%files -f %name.lang
%_bindir/%name
%_datadir/applications/%_name.desktop
%_datadir/dbus-1/services/%_name.service
%_iconsdir/hicolor/*/apps/*.*
%_man1dir/%name.1.*
%_datadir/appdata/%_name.appdata.xml
%_datadir/glib-2.0/schemas/%_name.gschema.xml
%doc README

%changelog
