Name: debootstrap
Version: 1.0.36
Release: alt2
Summary: Debian GNU/Linux bootstrapper

Group: System/Base
License: MIT
Url: http://code.erisian.com.au/Wiki/debootstrap
Packager: Denis Baranov <baraka@altlinux.ru>

Source: http://ftp.debian.org/debian/pool/main/d/debootstrap/%{name}_%version.tar
Source1: devices.tar.gz
Patch: debootstrap-devices.patch
Patch1: debootstrap-perms.patch

BuildArch: noarch

BuildRequires: fakeroot
Requires: gettext, wget, tar, gzip, binutils

%description
debootstrap is used to create a Debian base system from scratch, without
requiring the availability of dpkg or apt.  It does this by downloading
.deb files from a mirror site, and carefully unpacking them into a
directory which can eventually be chrooted into.

This might be often useful coupled with virtualization techniques to run
Debian GNU/Linux guest system.

%prep
%setup -n %{name}_%version
%patch0 -p1
%patch1 -p1
cp %SOURCE1 .

%build
# in Makefile, path is hardcoded, modify it to take rpm macros into account
%__subst 's;/usr/sbin;%_sbindir;' Makefile

# _smp_mflags would make no sense at all
fakeroot make

%install
install -d %buildroot%_datadir/debootstrap/scripts/
install -d %buildroot%_sbindir
install -d %buildroot%_man8dir
install -p -m 0644 debootstrap.8 %buildroot%_man8dir
%makeinstall_std \
       VERSION="%version-%release" \
       DSDIR=%buildroot%_datadir/debootstrap
# substitute the rpm macro path
%__subst 's;/usr/share;%_datadir;' %buildroot%_sbindir/debootstrap
# correct the debootstrap script timestamp
touch -r debootstrap  %buildroot%_sbindir/debootstrap

%files
%_datadir/debootstrap
%_sbindir/debootstrap
%_man8dir/debootstrap.8*
%doc debian/changelog debian/copyright README

%changelog
