%define _unpackaged_files_terminate_build 1
%set_verify_elf_method strict

Name: dhcpcd
Epoch: 1
Version: 6.11.7
Release: alt1

Summary: DHCP Client
License: %bsd
Group: System/Servers

URL: http://roy.marples.name/projects/%name
Source: %name-%version.tar
Patch0: %name-%version-%release.patch

AutoReq: yes, noshell

BuildRequires: rpm-build-licenses

Conflicts: etcnet < 0.9.10-alt6

# NetworkManager can use dhcpcd
Provides: nm-dhcp-client

%description
dhcpcd is an implementation of the DHCP client specified in RFC2131.

It gets the host information (IP address, netmask, broadcast address, etc.)
from a DHCP server and configures the network interface of the machine on
which it is running. It also tries to renew the lease time according to RFC2131.

%prep
%setup -q
%patch0 -p1

%build
%configure \
        --sbindir=/sbin \
        --rundir=/var/run \
        --libexecdir=/lib/%name \
        --dbdir=%_localstatedir/%name \
        --serviceexists='[ -x %_initdir/"$1" ]' \
        --servicecmd='/sbin/service "$1" >/dev/null 2>&1' \
        --with-hook=ntp.conf \
        --with-hook=lookup-hostname \
        --enable-ipv4 \
        --enable-ipv6 \
		--enable-dhcp6 \
		--enable-auth \
		--enable-ipv4ll \
        --without-udev
%make_build

%install
%makeinstall_std BINMODE=0755

%triggerpostun -- %name < 1:5.0.0
if grep -qs '^[[:blank:]]*clientid' %_sysconfdir/%name.conf; then
	echo "WARNING: *clientid* option is detected in %_sysconfdir/%name.conf."
	echo "The behavior of this option was changed since dhcpcd-5."
	echo "Now it means TO SEND clientid to the server."
fi

%files
/sbin/*
%_man8dir/*
%_man5dir/*
%config(noreplace) %_sysconfdir/%name.conf
%dir %_localstatedir/%name
%dir /lib/%name
%dir /lib/%name/%name-hooks
/lib/%name/%name-hooks/*
/lib/%name/%name-run-hooks

# Ingnore all additional hooks:
#   wpa_supplicant: wpa_supplicant should be handled by etcnet
#   tzupdate: it should use tzupdate but what about configuration files?
%exclude %_datadir/%name/

%changelog
