# INFO: For update, do git merge -s ours with new tag rom upstream repo
%ifndef e2k
%define e2k e2k e2kv4 e2kv5 e2kv6 e2k4c e2k8c e2k1cp e2k8c2 e2k12c e2k16c e2k2c3
%endif

%define major 0.97
Name: dia
Version: %major.4
Release: alt0.6.M80P.1

Summary: A gtk+ based diagram creation program
Summary(ru_RU.UTF-8): Программа для создания диаграмм, основанная на GTK+

License: GPL
Group: Office
Url: http://www.gnome.org/projects/dia

Packager: Valery Inozemtsev <shrek@altlinux.ru>

%py_provides dia
Obsoletes: %name-gnome %name-python

# Do not use: http://ftp.gnome.org/pub/gnome/sources/dia/%major/%name-%version.tar
# Source-git: https://git.gnome.org/browse/dia/
Source: %name-%version.tar
Source2: ru.po

#Patch: %name-%version-%release.patch
Patch: alt-dia-fix-help.patch
Patch2: alt-dia-improve-translation.patch

BuildRequires: dblatex docbook-style-xsl docbook-utils gcc-c++ intltool libart_lgpl-devel libgtk+2-devel libxslt-devel
BuildRequires: python-devel python-module-PyXML python-module-pygtk python-modules-email python-modules-encodings xsltproc
%ifnarch %e2k
BuildRequires: libEMF-devel
%endif
BuildRequires: libpng-devel
BuildRequires: desktop-file-utils

%description
Dia is a GNU program designed to be much like the Windows
program 'Visio'. It can be used to draw different kind of diagrams.

It can be used to draw a variety of diagram types, including UML, Network,
flowchart and others.  The native file format for Dia is XML (optionally
gzip compressed).  It has print support, and can export to a number of
formats such as EPS, SVG, CGM and PNG.

%description -l ru_RU.UTF-8
Программа Dia разработана как альтернатива Visio для Windows(TM). Dia
можно использовать для рисования различных типов диаграмм, она
включает поддержку структурных статических диаграмм UML (диаграмм
классов), моделирование отношений объектов и сетевых диаграмм. Dia
может загружать и сохранять диаграммы в собственном формате и в
формате .xml, а также экспортировать их в различные форматы, такие как
PostScript(TM), SVG, CGM или PNG.

%add_findprov_lib_path %_libdir/%name

%prep
%setup
#patch -p1
%patch -p1
%patch2 -p1

cp -f %SOURCE2 po/ru.po

install -m644 data/icons/48x48/apps/%name.png app/pixmaps/%name-app.png

%build
intltoolize --force
%autoreconf
%configure  \
	--enable-db2html \
	--with-hardbooks \
	--disable-gnome \
	--without-python \
%ifarch x86_64 %e2k
	--disable-libemf \
%endif
	--disable-static
%make_build

%install
%makeinstall_std
rm -rf %buildroot%_libdir/dia/*.la

%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Graphics \
	--add-category=Office \
	--add-category=Chart \
	%buildroot%_desktopdir/dia.desktop

%files -f %name.lang
%doc README TODO NEWS AUTHORS
%_docdir/dia/
%docdir %_docdir/dia/
%_bindir/%name
%dir %_libdir/%name
%_libdir/%name/*.so
%_datadir/%name/
%_datadir/mime-info/*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/%name.*
%_man1dir/*
%_mandir/fr/man1/*

%changelog
