%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl
%define vtkver 6.2

%define oname dolfin
%define scalar_type complex
%define ldir %_libdir/petsc-%scalar_type
Name: %oname-%scalar_type
Version: 1.6.0
Release: alt1.dev.git20150427
Epoch: 1
Summary: C++/Python library for solving differential equations
License: LGPL v3+
Group: Sciences/Mathematics
Url: http://fenicsproject.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://bitbucket.org/fenics-project/dolfin.git
Source: %oname-%version.tar.gz
Source1: CMakeCache.txt

Requires: python-module-%name = %epoch:%version-%release
Requires: python-module-%{name}_utils = %epoch:%version-%release
Requires: gcc%__gcc_version_base-c++ ufc-devel
Requires: lib%name = %epoch:%version-%release
BuildPreReq: python-module-petsc-config libdakota-devel eigen3
BuildPreReq: python-module-Pyro4 python-module-Scientific
BuildPreReq: python-module-fiat %mpiimpl-devel python-devel libcgal-devel
BuildPreReq: cmake swig libgts-devel libxml2-devel libnumpy-devel
BuildPreReq: boost-devel libvtk%vtkver-python-devel vtk%vtkver-python ufc-devel ffc
BuildPreReq: zlib-devel syfi libsyfi-devel
BuildPreReq: python-module-syfi python-module-ply python-module-Numeric
BuildPreReq: boost-filesystem-devel boost-program_options-devel
BuildPreReq: boost-math-devel boost-signals-devel boost-mpi-devel
BuildPreReq: libpetsc-%scalar_type-devel gcc-c++ libscotch-devel
BuildPreReq: libsuitesparse-devel libmtl4-devel libamesos10-devel
BuildPreReq: libparmetis-devel libgmp-devel
BuildPreReq: libgmpxx-devel libhdf5-mpi-devel cppunit-devel
BuildPreReq: libpytrilinos10-devel libtrilinos10-devel
BuildPreReq: python-module-PyTrilinos10 libmpfr-devel
BuildPreReq: libarmadillo-devel libhypre-devel libqd-devel
BuildPreReq: petsc-%scalar_type-sources python-module-sphinx-devel
#BuildPreReq: texlive-latex-extra ghostscript-utils
BuildPreReq: ghostscript-utils libhwloc-devel libqt4-devel libvtk%vtkver-devel
BuildPreReq: vtk%vtkver-examples libarprec-devel libtbb-devel
BuildPreReq: python-module-petsc4py-%scalar_type
BuildPreReq: python-module-slepc4py-%scalar_type
#BuildPreReq: libgomp-devel
BuildPreReq: libmumps-devel libnetcdf-mpi-devel
#BuildPreReq: libslepc-%scalar_type-devel

%description
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

Features:

  * Simple, consistent and intuitive object-oriented API in C++ or Python
  * Automatic and efficient evaluation of finite element variational forms
  through FFC or SyFi
  * Automatic and efficient assembly of linear systems
  * General families of finite elements, including arbitrary order continuous
  and discontinuous Lagrange finite elements, BDM elements, RT elements, BDFM
  elements, Nedelec elements and Crouzeix-Raviart
  * Arbitrary mixed elements as combination of basic elements, including for
  example Taylor-Hood
  * Discontinuous Galerkin methods including jump terms, averages, and integrals
  over interior mesh facets
  * High-performance linear algebra through uBLAS, PETSc, Trilinos and MTL4
  (experimental) with simple C++ and Python wrappers
  * Experimental support for parallel assembly
  * Simplex meshes in 1D, 2D (triangles), and 3D (tetrahedra), including
  adaptive mesh refinement
  * Multi-adaptive mcG(q)/mdG(q) and mono-adaptive cG(q)/dG(q) ODE solvers
  * Support for a range of input/output formats, including DOLFIN XML, VTK,
  Octave, MATLAB, Diffpack, Exodus II

%package -n lib%name
Summary: Shared library of DOLFIN
Group: System/Libraries
Requires: ffc
Requires: libsuitesparse >= 3.4.0-alt1
Requires: zlib >= 1.2.5-alt1

%description -n lib%name
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

This package contains shared library of DOLFIN.

%package -n lib%name-devel
Summary: Development files of DOLFIN
Group: Development/Other
Requires: lib%name = %epoch:%version-%release
Requires: %oname-devel-common = %version-%release
Requires: libsyfi-devel ufc-devel zlib-devel
Requires: libparmetis-devel >= 3.1.1-alt5
Requires: libsuitesparse-devel >= 3.4.0-alt1
Requires: gcc%__gcc_version_base-c++
Conflicts: %oname-devel-common < %epoch:%version-%release

%description -n lib%name-devel
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

This package contains development files of DOLFIN.

%package -n %oname-doc
Summary: Documentation for DOLFIN
Group: Documentation
BuildArch: noarch
Conflicts: %oname-real-doc
Obsoletes: %oname-real-doc

%description -n %oname-doc
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

This package contains documentation for DOLFIN.

%package -n %oname-examples
Summary: Examples for DOLFIN
Group: Documentation
BuildArch: noarch
%add_python_req_skip solution_dual mayavi stability_factors solution
%add_python_req_skip solution_1 solution_2 solution_3 solution_4
%add_python_req_skip solution_5 solution_6 solution_7 solution_8
%add_python_req_skip solution_9

%description -n %oname-examples
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

This package contains examples for DOLFIN.

%package -n %oname-example-data
Summary: Example data for DOLFIN
Group: Sciences/Mathematics
BuildArch: noarch

%description -n %oname-example-data
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

This package contains example data for DOLFIN.

%package -n python-module-%name
Summary: Python module of DOLFIN
Group: Development/Python
%add_python_lib_path %ldir/python
Requires: libpetsc-%scalar_type >= 3.0.0_p7-alt3
Requires: lib%name-devel = %epoch:%version-%release
Requires: python-module-vtk%vtkver
%setup_python_module %oname
%py_provides %oname
%py_requires multiprocessing
Provides: python-module-%oname = %epoch:%version-%release

%description -n python-module-%name
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

This package contains Python module of DOLFIN.

%package -n python-module-%{name}_utils
Summary: Utils Python module of DOLFIN
Group: Development/Python
%add_python_lib_path %ldir/python
Requires: libpetsc-%scalar_type >= 3.0.0_p7-alt3
Requires: lib%name = %epoch:%version-%release
Requires: python-module-vtk%vtkver
%setup_python_module %{oname}_utils
%py_provides %{oname}_utils
Provides: python-module-%{oname}_utils = %epoch:%version-%release

%description -n python-module-%{name}_utils
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

This package contains utils Python module of DOLFIN.

%package -n %oname-tests
Summary: Tests and benchmarks for DOLFIN
Group: Development/Other
BuildArch: noarch

%description -n %oname-tests
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

This package contains tests and benchmarks for DOLFIN.

%package -n %oname-devel-common
Summary: Scalar type independent development files of DOLFIN
Group: Development/Other
Conflicts: lib%name-devel < %epoch:%version-%release
Requires: python-module-numpy >= 1.4.0-alt1.svn20090822
Requires: zlib-devel >= 1.2.5-alt1

%description -n %oname-devel-common
DOLFIN is the C++/Python interface of FEniCS, providing a consistent PSE
(Problem Solving Environment) for ordinary and partial differential equations.

This package contains Scalar type independent development files of DOLFIN.

%prep
%setup

cmake/scripts/generate-all

mkdir BUILD
pushd BUILD
install -p -m644 %SOURCE1 .
sed -i 's|@SCALAR_TYPE@|%scalar_type|g' CMakeCache.txt \
	../site-packages/dolfin/compilemodules/__init__.py
sed -i 's|@LIBDIR@|%_libdir|g' CMakeCache.txt
%ifarch x86_64
LIB64=64
%endif
sed -i "s|@64@|$LIB64|g" CMakeCache.txt
#	test/memory/dolfin_valgrind.supp
popd

cp -f %oname/scons/pkgconfig/gmp.pc \
	%_pkgconfigdir/mtl4.pc %_pkgconfigdir/zlib.pc \
	pkgconfig/
sed -i 's|2\.1\.1|4.2.4|g' pkgconfig/mtl4.pc

%build
mpi-selector --set %mpiimpl
source /usr/bin/petsc-%scalar_type.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

LDFLAGS="-L%mpidir/lib -Wl,-rpath,%mpidir/lib"
export LDFLAGS="$LDFLAGS -L$PETSC_DIR/lib -Wl,-rpath,$PETSC_DIR/lib"
export LIBDIR=%_libdir

mkdir -p CMakeFiles/cmTryCompileExec.dir
pushd BUILD
cmake -DCMAKE_INSTALL_PREFIX:PATH=$PETSC_DIR ..
sed -i \
	's|^\(GMP_LIBRARIES.*\)|\1;%_libdir/libgmpxx.so;%_libdir/libmpfr.so|' \
	CMakeCache.txt
%make_build
popd

%install
source /usr/bin/petsc-%scalar_type.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

./cmake/scripts/generate-swig-docstrings

pushd BUILD
%makeinstall_std

install -d %buildroot%ldir/lib
install -d %buildroot%ldir/include
install -d %buildroot%ldir/python
install -d %buildroot%_datadir/%oname
install -d %buildroot%_pkgconfigdir
install -d %buildroot%_bindir

mv %buildroot$PETSC_DIR/share/%oname/demo %buildroot%_datadir/%oname/examples
mv %buildroot$PETSC_DIR/share/%oname/data %buildroot%_datadir/%oname/
#rm -f examples/pde/nonlinear-poisson/cpp/plot.py* \
#	examples/ode/stiff/cpp/plot.py* \
#	$(egrep -R 'solution\ import' examples |awk -F : '{print $1}')
cp -fR ../bench ../test %buildroot%_datadir/%oname/
popd
for i in $(egrep -R '@PKG_NAME@' %buildroot%_datadir/%oname/|awk -F : '{print $1}')
do
	sed -i 's|@PKG_NAME@|%name|g' $i
done

mv %buildroot$PETSC_DIR/bin/* %buildroot%_bindir/
rmdir %buildroot$PETSC_DIR/bin
mv %buildroot$PETSC_DIR/share/man %buildroot%_datadir/
rm -fR %buildroot$PETSC_DIR/share/man
%if "%scalar_type" == "complex"
pushd %buildroot%_bindir
mv dolfin-convert dolfin-convert-complex
mv dolfin-order dolfin-order-complex
popd
pushd %buildroot%_man1dir
mv dolfin-convert.1.gz dolfin-convert-complex.1.gz
mv dolfin-order.1.gz dolfin-order-complex.1.gz
popd
%endif

cp %_includedir/ufc.h %buildroot%ldir/include/%oname/
cp %_includedir/swig/ufc.i %buildroot%ldir/include/%oname/swig/

rm -f pkgconfig/zlib.pc pkgconfig/mtl4.pc
BOOST_VERSION=$(rpm -q --qf "%{VERSION}" boost-devel)
sed -i "s|^\(Version:\).*|\1 $BOOST_VERSION|" \
	pkgconfig/boost*.pc
cp -f pkgconfig/*.pc %buildroot%_pkgconfigdir
mv %buildroot$PETSC_DIR/lib/pkgconfig/%oname.pc \
	%buildroot%_pkgconfigdir/%name.pc

mv %buildroot$PETSC_DIR/%_lib/python%_python_version/site-packages/* \
	%buildroot%ldir/python/
rm -fR %buildroot$PETSC_DIR/%_lib/python%_python_version
%ifarch x86_64
mv %buildroot$PETSC_DIR/lib/python%_python_version/site-packages/* \
	%buildroot%ldir/python/
rm -fR %buildroot$PETSC_DIR/lib/python%_python_version
%endif

ln -s %_includedir/swig %buildroot$PETSC_DIR/include/

# fix bug in pkgconfig file
sed -i 's|debug optimized||' %buildroot%_pkgconfigdir/%name.pc

export PYTHONPATH=%buildroot%ldir/python
export LD_LIBRARY_PATH=%buildroot%ldir/lib
#make -C BUILD/doc doc

%files
%doc AUTHORS COPYING ChangeLog README*
%_bindir/*
%exclude %_bindir/dolfin-get-demos
%_man1dir/*

%files -n lib%name
%ldir/lib/*.so.*

%files -n lib%name-devel
%ldir/lib/*.so
%ldir/include/*
%ldir/share/%oname
%_pkgconfigdir/%name.pc

%if "%scalar_type" == "real"
%files -n %oname-devel-common
%_pkgconfigdir/*
%exclude %_pkgconfigdir/%name.pc

#files -n %oname-doc
#doc %dir %_docdir/%oname
#doc %_docdir/%oname

%files -n %oname-examples
%_bindir/dolfin-get-demos
%dir %_datadir/%oname
%_datadir/%oname/examples

%files -n %oname-tests
%dir %_datadir/%oname
%_datadir/%oname/test
%_datadir/%oname/bench

%files -n %oname-example-data
%dir %_datadir/%oname
%_datadir/%oname/data
%endif

%files -n python-module-%name
%dir %ldir/python
%ldir/python/%oname
%ldir/python/fenics

%files -n python-module-%{name}_utils
%dir %ldir/python
%ldir/python/%{oname}_utils

%changelog
