%define _unpackaged_files_terminate_build 1

%def_without bootstrap
%define pre %nil

Name: dotnet
Version: 2.1.9
Release: alt2

Summary: Installer packages for the .NET Core runtime and libraries

License: MIT
Url: https://github.com/dotnet/core-setup
Group: Development/Other

# Source-url: %url/archive/v%version%pre.tar.gz
Source: %name-%version.tar

ExclusiveArch: x86_64

BuildRequires: clang llvm

BuildRequires: cmake libstdc++-devel

BuildRequires(pre): rpm-macros-dotnet = %version

BuildRequires: dotnet-common = %version

# FIXME
#Requires: dotnet-common >= %_dotnet_major
Requires: dotnet-common >= 2.1
Requires: dotnet-coreclr = %version
Requires: dotnet-corefx = %version
#Requires: dotnet-sdk >= %version

%if_with bootstrap
BuildRequires: dotnet-bootstrap
%define bootstrapdir %_libdir/dotnet-bootstrap
%else
#BuildRequires: dotnet
%define bootstrapdir %_dotnetdir
%endif


%description
This repo contains the code to build the .NET Core runtime,
libraries and shared host (dotnet) installers for all supported platforms.
It does not contain the actual sources to .NET Core runtime;
this source is split across the dotnet/coreclr repo (runtime)
and dotnet/corefx repo (libraries).

%prep
%setup
# since glibc 2.26 xlocale.h is removed
%__subst "s|xlocale.h|locale.h|" src/corehost/cli/json/casablanca/include/cpprest/asyncrt_utils.h

find -type f -name "*.sh" | xargs subst "s|/etc/os-release|%_dotnetdir/fake-os-release|g"

%build
#DOTNET_TOOL_DIR=%_libdir/dotnet-bootstrap ./build.sh x64 release verbose
cd src/corehost
#DOTNET_TOOL_DIR=%bootstrapdir
sh -x ./build.sh \
    --arch x64 \
    --hostver %_dotnet_corerelease \
    --apphostver %_dotnet_corerelease \
    --fxrver %_dotnet_corerelease \
    --policyver %_dotnet_corerelease \
    -portable \
    --commithash 0 || make -C bin/obj/Linux.x64.Release
# (parallel generation fail workaround)

%install
mkdir -p %buildroot%_dotnetdir/
install -m755 src/corehost/cli/exe/dotnet/dotnet %buildroot%_dotnetdir/
install -m755 src/corehost/cli/exe/apphost/apphost %buildroot%_dotnetdir/

mkdir -p %buildroot%_dotnet_shared/
install -m755 src/corehost/cli/dll/libhostpolicy.so %buildroot%_dotnet_shared/
#install -m755 src/corehost/cli/fxr/libhostfxr.so %buildroot%_dotnet_shared/
mkdir -p %buildroot%_dotnet_hostfxr/
install -m755 src/corehost/cli/fxr/libhostfxr.so %buildroot%_dotnet_hostfxr/

mkdir -p %buildroot%_bindir/
ln -sr %buildroot%_dotnetdir/dotnet %buildroot%_bindir/dotnet

%files
%doc THIRD-PARTY-NOTICES.TXT README.md CONTRIBUTING.md LICENSE.TXT
%_bindir/dotnet
%_dotnetdir/dotnet
%_dotnetdir/apphost

%dir %_dotnet_hostfxr/
%_dotnet_hostfxr/libhostfxr.so
%_dotnet_shared/libhostpolicy.so

%changelog
