Name: dynamips
Version: 0.2.16
Release: alt1

Summary: Cisco 7200 Simulator
License: GPLv2
Group: Emulators

Url: http://www.gns3.net
#Url: https://github.com/GNS3/dynamips

Source: %name-%version.tar
BuildRequires(pre): rpm-macros-cmake cmake 
BuildRequires: libelf-devel libpcap-devel libuuid-devel

%description
A project to emulate a Cisco 7200 on a traditionnal PC.
The emulator currently supports the following platforms:
 - Cisco 7200 (NPE-100 to NPE-400)
 - Cisco 3600 (3620, 3640 and 3660)
 - Cisco 2691
 - Cisco 3725
 - Cisco 3745
 - Cisco 2600 (2610 to 2650XM)
 - Cisco 1700 (1710 to 1760)

The goals of this emulator are mainly:
    * To be used as a training platform, with software used in real world. It
      would allow people to become more familiar with Cisco devices, Cisco
      being the world leader in networking technologies ;
    * Test and experiment the numerous and powerful features of Cisco IOS ;
    * Check quickly configurations to be deployed later on real routers.

%prep
%setup

%build
%cmake
%make_build -C BUILD

%install
%makeinstall_std -C BUILD
install -d %buildroot%_localstatedir/%name/{labs,images}
rm -fR %buildroot%_datadir/doc/%name

%files
%doc COPYING README* TODO ChangeLog RELEASE-NOTES
%_man1dir/*
%_man7dir/hypervisor_mode.7*
%_bindir/*
%dir %_localstatedir/%name
%dir %_localstatedir/%name/images
%dir %_localstatedir/%name/labs

%changelog
