%define cvs_date 20080410

Name: edb
Version: 1.0.5.042
Release: alt5.%cvs_date

Summary: Enlightenment Database Access Library
License: BSD-like
Group: Graphical desktop/Enlightenment
Url: http://www.enlightenment.org/
Source: %name-%version.tar.bz2
Patch: edb-1.0.5.042-alt-link.patch

%def_disable static
%{?_enable_static:BuildPreReq: glibc-devel-static}

BuildRequires: gtk+-devel libncurses-devel zlib-devel

%description
Edb is a database abstraction layer to Berkeley Databases. Edb contains the
source for DB 2.7.7, thus freezing the database format on disk, making sure it
will never become incompatible (as is a habit of the DB interface in libc). Edb
wraps this with a convenience and optimization API layer, making database
access easy, fast and consistent. It handles typing of information in the
database and much more.

%package -n lib%name
Summary: Graphical desktop/Enlightenment
Group: System/Libraries

%description -n lib%name
Edb is a database abstraction layer to Berkeley Databases. Edb contains the
source for DB 2.7.7, thus freezing the database format on disk, making sure it
will never become incompatible (as is a habit of the DB interface in libc). Edb
wraps this with a convenience and optimization API layer, making database
access easy, fast and consistent. It handles typing of information in the
database and much more.

This package contains shared library required for %name-based software.

%package -n lib%name-devel
Summary: Include files for development with Enlightenment Database Access Library
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Edb is a simple, clean high-level db access/storage library.

This package contains include files required for development %name-based software.

%package -n lib%name-devel-static
Summary: Static library for development with Enlightenment Database Access Library
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Edb is a simple, clean high-level db access/storage library.

This package contains static library required for development statically linked
%name-based software.

%package -n %{name}_ed
Summary: Edb command-line editor
Group: Graphical desktop/Enlightenment
Requires: lib%name = %version-%release
Conflicts: %name-utils

%description -n %{name}_ed
A command-line db editor for Edb

%package -n %{name}_gtk_ed
Summary: Edb GTK+ editor
Group: Graphical desktop/Enlightenment
Requires: lib%name = %version-%release
Conflicts: %name-utils

%description -n %{name}_gtk_ed
A GTK+ gui db editor for Edb

%package -n %{name}_vt_ed
Summary: Edb curses editor
Group: Graphical desktop/Enlightenment
Requires: lib%name = %version-%release
Conflicts: %name-utils

%description -n %{name}_vt_ed
A curses db editor for Edb

%prep
%setup -q -n %name
%patch -b .link

%build
export NOCONFIGURE=yes
sh autogen.sh

%{?!_enable_static:export lt_cv_prog_cc_static_works=no}
%configure \
	--enable-cxx \
	%{subst_enable static}
%make_build

%install
%make_install DESTDIR=%buildroot install

%files -n lib%name
%_libdir/*.so.*
%doc AUTHORS COPYING COPYING-PLAIN README src/LICENSE

%files -n lib%name-devel
%_libdir/pkgconfig/edb.pc
%_libdir/*.so
%_includedir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files -n %{name}_ed
%_bindir/%{name}_ed

%files -n %{name}_gtk_ed
%_bindir/%{name}_gtk_ed

%files -n %{name}_vt_ed
%_bindir/%{name}_vt_ed

%changelog
