# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
Name: eepm
Version: 3.4.0
Release: alt1.M80P.2

Summary: Etersoft EPM package manager

License: AGPL-3.0+
Group: System/Configuration/Packaging
Url: http://wiki.etersoft.ru/EPM

Packager: Vitaly Lipatov <lav@altlinux.ru>

# git-clone http://git.etersoft.ru/projects/korinf/eepm.git
Source: ftp://updates.etersoft.ru/pub/Etersoft/Sisyphus/sources/tarball/%name-%version.tar

BuildArchitectures: noarch

# Contains the same command epm
Conflicts: epm

Provides: upm

%if %_vendor == "alt"
# FIXHERE: Replace with target platform package manager
Requires: apt rpm
Requires: distro_info >= 1.6
%endif

%description
Etersoft EPM is the package manager for any platform
and any platform version. It provides
universal interface to any package manager.
Can be useful for system administrators working
with various distros.

See detailed description here: http://wiki.etersoft.ru/EPM

%package repack
Summary: Etersoft EPM package manager (repack requirements)
Group: System/Configuration/Packaging
Requires: %name = %EVR
Requires: fakeroot alien rpm-build dpkg

%description repack
This package has requirements needed for using epm repack on ALT
(repack rpm packages and repack/install deb packages).

See https://bugzilla.altlinux.org/show_bug.cgi?id=34308 for
a discussion about extra requirements.

Requires: fakeroot alien rpm-build dpkg

%prep
%setup

%install
# install to datadir and so on
# do not use uncommon makeinstall_std here
%make_install install DESTDIR=%buildroot datadir=%_datadir bindir=%_bindir mandir=%_mandir sysconfdir=%_sysconfdir version=%version-%release
#install -m 0755 packed/epm.sh %buildroot/%_datadir/%name/epm-packed.sh
#install -m 0755 packed/serv.sh %buildroot/%_datadir/%name/serv-packed.sh

mkdir -p %buildroot%_sysconfdir/eepm/
cat <<EOF >%buildroot%_sysconfdir/eepm/eepm.conf
# EEPM config (will insource in epm shell script)
# Not known variable yet

#verbose=--verbose
#quiet==--quiet
EOF

cat <<EOF >%buildroot%_sysconfdir/eepm/serv.conf
# EEPM config (will insource in serv shell script)
EOF

mkdir -p %buildroot%_sysconfdir/eepm/repack.d/
cp repack.d/*.sh %buildroot%_sysconfdir/eepm/repack.d/
chmod 0755 %buildroot%_sysconfdir/eepm/repack.d/*.sh

mkdir -p %buildroot%_sysconfdir/eepm/prescription.d/
cp prescription.d/*.sh %buildroot%_sysconfdir/eepm/prescription.d/
chmod 0755 %buildroot%_sysconfdir/eepm/prescription.d/*.sh

mkdir -p %buildroot%_sysconfdir/bash_completion.d/
install -m 0644 bash_completion/serv %buildroot%_sysconfdir/bash_completion.d/serv
ln -s serv %buildroot%_sysconfdir/bash_completion.d/cerv

# shebang.req.files
chmod a+x %buildroot%_datadir/%name/{serv-,epm-}*
chmod a+x %buildroot%_datadir/%name/tools_*

%if %_vendor == "alt"
# use external eget
rm -f %buildroot%_datadir/%name/tools_eget
# use external distro_info
rm -f %buildroot%_bindir/distr_info
%endif

%files
%doc README.md TODO LICENSE
%dir %_sysconfdir/eepm/
%dir %_sysconfdir/eepm/repack.d/
%dir %_sysconfdir/eepm/prescription.d/
%config(noreplace) %_sysconfdir/eepm/eepm.conf
%config(noreplace) %_sysconfdir/eepm/serv.conf
%config(noreplace) %_sysconfdir/eepm/repack.d/*.sh
%config(noreplace) %_sysconfdir/eepm/prescription.d/*.sh
%_bindir/epm*
%_bindir/eepm
%_bindir/upm
%_bindir/serv
%_bindir/cerv
%if %_vendor != "alt"
%_bindir/distr_info
%endif
%_man1dir/*
%_datadir/%name/
%_sysconfdir/bash_completion.d/serv
%_sysconfdir/bash_completion.d/cerv

%if %_vendor == "alt"
%files repack
%endif

%changelog
