%define _user _eggdrop
%define _group _eggdrop
%define _home %_localstatedir/%name

Name: eggdrop
Version: 1.6.21
Release: alt3

Summary: Eggdrop is an IRC bot, written in C
License: GPL
Group: Networking/IRC

Url: http://www.eggheads.org
Packager: Vladimir V Kamarzin <vvk@altlinux.ru>

Source0: %name-%version.tar
Source1: %name.README.ALT.UTF8
Source2: %name.init
Patch1:  %name-clang-ftbfs.patch
Patch2:  %name-fix-config-interpreter.patch

BuildRequires: tcl-devel zlib-devel autoconf_2.5
%add_findreq_skiplist %_datadir/%name/scripts/*

%description
Eggdrop is an IRC bot, written in C.  If you don't know what IRC is,
this is probably not whatever you're looking for!  Eggdrop, being a
bot, sits on a channel and takes protective measures: to keep the
channel from being taken over (in the few ways that anything CAN),
to recognize banished users or sites and reject them, to recognize
privileged users and let them gain ops, etc.

%prep
%setup
%patch1 -p1
%patch2 -p2

%build
autoconf
%configure
make config
%make_build

%install
install -dm1770 %buildroot%_var/run/%name
install -dm1770 %buildroot%_logdir/%name

mkdir -p %buildroot%_libdir/%name/
mkdir -p %buildroot%_datadir/%name
mkdir -p %buildroot%_docdir/%name-%version/
mkdir -p %buildroot%_man1dir/
mkdir -p %buildroot%_logdir/%name

%make DEST=%buildroot%_datadir/%name install

# Move modules into /usr/lib*
mkdir -p %buildroot%_libdir
mv -f %buildroot%_datadir/%name/modules* %buildroot%_libdir/%name

# move binaries
mkdir -p %buildroot%_bindir
mv -f %buildroot%_datadir/%name/{%name,%name-%version} %buildroot%_bindir

# initscript
install -pDm0755 %SOURCE2 %buildroot%_initdir/%name

# manpage
install -m644 doc/man1/%name.1 %buildroot%_man1dir
rm -rf doc/man1

# Fix paths of example eggdrop.conf
sed -i  -e "s,scripts/,%_datadir/%name/scripts/,g" \
	-e "s,help/,%_datadir/%name/help/,g" \
	-e "s,modules/,%_libdir/%name/modules/,g" \
	-e "s,language/,%_datadir/%name/language/,g" \
	-e "s,text/,%_datadir/%name/text/,g" %name.conf
install -pDm0755 eggdrop.conf %buildroot%_datadir/%name/%name.conf
install -pDm0755 eggdrop.conf %buildroot%_home/eggdrop.conf

# README.ALT
install -pDm0644 %SOURCE1 README.ALT.UTF8

# scripts directory
install -dm1770 %buildroot%_home/scripts

# remove unnedded stuff
rm -rf %buildroot%_datadir/%name/doc

%pre
/usr/sbin/groupadd -r -f %_group ||:
/usr/sbin/useradd -g %_group -c 'The eggdrop' \
        -d %_home -s /dev/null -r %_user >/dev/null 2>&1 ||:

%files
%dir %_libdir/%name
%dir %_datadir/%name/language
%dir %_libdir/%name/modules-%version
%dir %_datadir/%name/help
%dir %_datadir/%name/help/set
%dir %_datadir/%name/help/msg
%dir %_datadir/%name/scripts
%dir %_datadir/%name/text
%dir %attr(1770,root,%_group) %_home
%dir %attr(1770,root,%_group) %_home/scripts
%dir %attr(1770,root,%_group) %_var/run/%name
%dir %attr(1770,root,%_group) %_logdir/%name
%config(noreplace) %_home/%name.conf
%_initdir/%name
%_bindir/%name
%_bindir/%name-%version
%_libdir/%name/modules
%_libdir/%name/modules-%version/*.so
%_datadir/%name/*
%_man1dir/%name.1.*
%doc doc/* README*

%changelog
