Name: elfutils
Version: 0.168
Release: alt1

Summary: A collection of utilities and DSOs to handle ELF files and DWARF data
License: GPLv3+ and (GPLv2+ or LGPLv3+)
Group: Development/C
URL: https://sourceware.org/elfutils/
# git://git.altlinux.org/gears/e/elfutils.git
Source: %name-%version-%release.tar

Requires: libelf = %EVR

%def_enable static
%def_enable check

BuildRequires: bzlib-devel flex liblzma-devel libstdc++-devel zlib-devel
%{?_enable_check:BuildRequires: /proc}

%define _gnu %nil
%define _configure_script ../configure
%define buildtarget build-%_target_platform

%description
Elfutils is a collection of utilities, including ld (a linker), nm
(for listing symbols from object files), size (for listing the section
sizes of an object or archive file), strip (for discarding symbols),
readelf (to see the raw ELF file structures), and elflint (to check for
well-formed ELF files).  Also included are numerous helper libraries
which implement DWARF, ELF, and machine-specific ELF handling.

%package devel
Summary: Development libraries to handle compiled objects
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: %name = %EVR
Requires: libelf-devel = %EVR

%description devel
This package contains the libraries to create applications for
handling compiled objects.  libebl provides some higher-level ELF access
functionality.  libdw provides access to the DWARF debugging information.
libasm provides a programmable assembler interface.

%package devel-static
Summary: Static archives to handle compiled objects
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: %name-devel = %EVR
Requires: libelf-devel-static = %EVR

%description devel-static
This package contains static archives with the code to handle compiled objects.

%package -n libelf
Summary: Library to read and write ELF files
License: GPLv2+ or LGPLv3+
Group: System/Libraries

%description -n libelf
This package provides a DSO which allows reading and writing ELF files
on a high level.  Third party programs depend on this package to read
internals of ELF files.  The programs of the elfutils package use it
also to generate new ELF files.

%package -n libelf-devel
Summary: Development libelf library
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libelf = %EVR

%description -n libelf-devel
This package contains the library to create applications for handling
compiled objects.  libelf allows you to access the internals of the ELF
object file format, so you can see the different sections of an ELF file.

%package -n libelf-devel-static
Summary: Static libelf library
License: GPLv2+ or LGPLv3+
Group: Development/C
Requires: libelf-devel = %EVR

%description -n libelf-devel-static
This package contains static libelf library.

%prep
%setup -n %name-%version-%release

%build
%add_optflags -fexceptions
%autoreconf
rm -rf %buildtarget
mkdir %buildtarget
cd %buildtarget
%configure \
	--disable-silent-rules \
	--enable-dependency-tracking \
	--enable-maintainer-mode \
	--program-prefix=eu-
%make_build

%install
%makeinstall_std -C %buildtarget
%find_lang %name
%set_verify_elf_method strict,rpath=normal

%check
export PATH="%buildroot%_bindir:$PATH" LD_LIBRARY_PATH=%buildroot%_libdir
%make_build -k check -C %buildtarget

%files
%_bindir/eu-addr2line
%_bindir/eu-ar
%_bindir/eu-elfcmp
%_bindir/eu-elfcompress
%_bindir/eu-elflint
%_bindir/eu-findtextrel
%_bindir/eu-make-debug-archive
%_bindir/eu-nm
%_bindir/eu-objdump
%_bindir/eu-ranlib
%_bindir/eu-readelf
%_bindir/eu-size
%_bindir/eu-stack
%_bindir/eu-strings
%_bindir/eu-strip
%_bindir/eu-unstrip
%_libdir/libasm-*.so
%_libdir/libdw-*.so
%_libdir/libasm*.so.*
%_libdir/libdw*.so.*
%_libdir/elfutils/

%files devel
%_includedir/dwarf.h
%_includedir/elfutils/
%_libdir/libasm.so
%_libdir/libdw.so
%_libdir/libebl.a
%_pkgconfigdir/*.pc

%if_enabled static
%files devel-static
%_libdir/libasm.a
%_libdir/libdw.a
%endif

%files -n libelf -f %name.lang
%doc AUTHORS CONTRIBUTING NEWS NOTES README THANKS
%_libdir/libelf-*.so
%_libdir/libelf*.so.*

%files -n libelf-devel
%_includedir/libelf.h
%_includedir/gelf.h
%_includedir/nlist.h
%_libdir/libelf.so

%if_enabled static
%files -n libelf-devel-static
%_libdir/libelf.a
%endif

%changelog
