Name: elilo
Version: 3.14
Release: alt1.5926535

Summary: EFI Linux Loader
License: GPL v2+
Group: System/Kernel and hardware

Url: http://elilo.sourceforge.net
Source0: http://downloads.sourceforge.net/elilo/%name-%version-all.tar.gz
Source1: debian.eliloalt.man8
Source2: elilo.conf.man5

BuildRequires: rpm-macros-uefi
BuildRequires: pesign >= 0.109-alt4
BuildRequires: gnu-efi = 3.0r
BuildRequires: gnu-efi >= 3.0d
BuildConflicts: gnu-efi = 3.0s
BuildConflicts: gnu-efi = 3.0t

ExclusiveArch: x86_64

Obsoletes: elilo-signed

Summary(pl.UTF-8): Linuksowy bootloader dla platform EFI

%description
ELILO is an EFI Linux boot loader for IA-64 (IPF), IA-32 (x86)
and x86_64 EFI-based platforms.

This package might hold pre-signed ELILO binary
to cope with UEFI SecureBoot (rather Restricted Boot).

%description -l pl.UTF-8
ELILO to linuksowy bootloader dla platform IA-64 (IPF), IA-32 (x86)
oraz x86_64 opartych na EFI.

%prep
%setup -c
tar xf %name-%version-source.tar.gz

%build
%make -C elilo -j1 \
	ARCH=$(arch | sed -e 's/i.86/ia32/') \
	OPTIMFLAGS="%optflags" \
	EFICRT0=%_libdir \
	EFILIB=%_libdir \
	GNUEFILIB=%_libdir

%install
install -pDm755 elilo/tools/eliloalt %buildroot%_sbindir/eliloalt
install -pDm644 elilo/elilo.efi %buildroot%_efi_bindir/elilo.efi
install -pDm644 %SOURCE1 %buildroot%_man8dir/eliloalt.8
install -pDm644 %SOURCE2 %buildroot%_man5dir/elilo.conf.5

%ifarch x86_64
%pesign -s -i %buildroot%_efi_bindir/elilo.efi
%endif

%files
%doc %version-release-notes.txt elilo/{ChangeLog,README*,TODO}
%doc elilo/docs/*.txt elilo/examples
%_sbindir/eliloalt
%_efi_bindir/elilo.efi
%_man8dir/eliloalt.8*
%_man5dir/elilo.conf.5*

%changelog
