Name: elinks
Version: 0.12
Release: alt0.11

Summary: Lynx-like text WWW browser with many features
License: GPLv2
Group: Networking/WWW

URL: http://elinks.cz
Source: elinks-0.12pre5.tar
Patch: %name-%version-%release.patch

# alternatives
%set_compress_method gzip
%define weight 30
PreReq: alternatives >= 0.2.0
BuildPreReq: alternatives >= 0.2.0

Provides: webclient, links
Provides: %_bindir/links
Obsoletes: links

# Automatically added by buildreq on Wed Sep 30 2009
BuildRequires: bzlib-devel docbook-utils libexpat-devel libgpm-devel liblua5-devel libssl-devel python-modules-encodings xmlto zlib-devel

%description
ELinks is advanced text-mode web browser with wide scale of additional
features and extensibility by possibility to plug in own scripts in Lua
language. This project aims to provide feature-rich version of Links,
with more open patches/features inclusion policy.

%prep
%setup -n elinks-0.12pre5
%patch -p1

%build
cat config/m4/*.m4 >acinclude.m4
%autoreconf
export ac_cv_prog_HAVE_SMBCLIENT=no
%configure %{subst_enable debug} \
	--sysconfdir=/etc/elinks \
	--without-x \
	--enable-utf-8 \
	--enable-256-colors \
	--enable-cgi \
	--enable-finger \
	--enable-gopher \
	--enable-nntp \
	--disable-smb \
	--disable-leds \
	--without-spidermonkey \
	--without-idn \
	--without-lzma \
	#
touch src/intl/gettext/plural.y
make -C src/intl/gettext V=1 plural.c
sed -i 's/^YYSTYPE yylval/& = {0}/' src/intl/gettext/plural.c

make -C src V=1 CFLAGS="%optflags -fno-strict-aliasing -Wno-pointer-sign -Werror"
make -C doc V=1 features.txt manual.html

%install
%makeinstall_std V=1

mkdir -p %buildroot%_altdir
cat <<__EOF__ >%buildroot%_altdir/elinks
%_bindir/links		%_bindir/elinks		%weight
%_man1dir/links.1.gz	%_man1dir/elinks.1.gz	%_bindir/elinks
__EOF__

install -pD -m644 elinks.conf %buildroot/etc/elinks/elinks.conf

%find_lang elinks

%files -f elinks.lang
%_bindir/elinks
%dir /etc/elinks
%config(noreplace) /etc/elinks/elinks.conf
%_man1dir/elinks.*
%_man5dir/elinks*
%_altdir/elinks
%doc AUTHORS COPYING NEWS README THANKS
%doc doc/manual.html

%changelog
