# -*- coding: latin-1; mode: rpm-spec -*-

%define pkg_name jabber
Epoch: 1

Version: 0.8.92
Release: alt7.1
Name: emacs-jabber
License: %gpl2plus
Group: Networking/Instant messaging
Url: http://emacs-jabber.sourceforge.net
Summary: A minimal jabber client for Emacs

Packager: Emacs Maintainers Team <emacs@packages.altlinux.org>

Source: %name-%version.tar

BuildArch: noarch
Requires: emacs-common emacs-gnus >= 5.10

BuildPreReq: emacs-devel >= 0.0.1-alt2

BuildPreReq: emacs-common
BuildPreReq: rpm-build-licenses
BuildPreReq: emacs-gnus >= 5.10
# We need automake >= 1.12 to support LOG_COMPILER:
BuildPreReq: automake >= 1.12
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
jabber.el is a minimal Jabber client running under Emacs.

Recommends: xprintidle

%package el
Summary: The Emacs Lisp sources for bytecode included in %name
Group: Development/Other
Requires: %name = %EVR

%description el
%name-el contains the Emacs Lisp sources for the bytecode
included in the %name package, that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

%prep
%setup
%build

%install
%autoreconf
%configure --with-lispdir=%_emacslispdir/%pkg_name
make install DESTDIR=%buildroot abs_builddir="%_builddir/%name-%version"
pushd tests
make check
popd

mkdir -p %buildroot%_bindir
mv -v %buildroot%_libexecdir/%name-uri-handler %buildroot%_bindir

mkdir -p %buildroot%_emacs_sitestart_dir
install -m 644 jabber-emacs.el %buildroot%_emacs_sitestart_dir/%pkg_name.el

# Hexrgb
%byte_compile_file jabber-fallback-lib/hexrgb.el
install -m 644 jabber-fallback-lib/hexrgb.el %buildroot%_emacslispdir/%pkg_name/hexrgb.el
install -m 644 jabber-fallback-lib/hexrgb.elc %buildroot%_emacslispdir/%pkg_name/hexrgb.elc

%files
%_bindir/*
%dir %_emacslispdir/%pkg_name
%_emacslispdir/%pkg_name/*.elc
%_emacslispdir/%pkg_name/jabber-autoloads.el
%_infodir/%pkg_name.info*
%config(noreplace) %_emacs_sitestart_dir/%pkg_name.el
%doc README AUTHORS NEWS

%files el
%_emacslispdir/%pkg_name/*.el
%exclude %_emacslispdir/%pkg_name/jabber-autoloads.el
%doc %pkg_name.texi

%changelog
