# -*- coding: utf-8; mode: rpm-spec -*-
# $Id: emacs-jdee.spec,v 1.8 2006/05/03 12:51:02 eugene Exp $

Version: 2.4.0.1
# %define subver beta6
Release: alt2
Name: emacs-jdee
License: GPL
Group: Editors
Url: http://jdee.sourceforge.net/
Summary: Java Development Environment for Emacs
Summary(ru_RU.UTF-8): Среда разработки Java для Emacs

Packager: Emacs Maintainers Team <emacs@packages.altlinux.org>

Requires: emacs-common emacs-cedet emacs-elib 

Source: jdee-%version.tar.gz
Source1: jde-emacs.el

Patch: jdee-2.4.0.1-java.patch

BuildArch: noarch

# Automatically added by buildreq on Thu Jul 18 2002
BuildRequires: emacs-common emacs-base emacs-elib emacs-cedet emacs-devel emacs-leim

BuildRequires: ant ant-contrib

%description
The Java Development Environment for GNU Emacs is a software package that interfaces
Emacs to command-line Java development tools. JDEE features include:
    * JDEE menu with compile, run, debug, build, browse, project, and help commands
    * syntax coloring
    * auto indentation
    * compile error to source links
    * source-level debugging
    * source code browsing
    * make file support
    * automatic code generation
    * Java source interpreter

All Emacs Lisp code is byte-copmpiled, install %name-el for sources.

%package el
Summary: The Emacs Lisp sources for bytecode included in %name
Group: Development/Other
Requires: %name = %version-%release

%description el
%name-el contains the Emacs Lisp sources for the bytecode
included in the %name package, that extends the Emacs editor.

You need to install %name-el only if you intend to modify any of the
%name code or see some Lisp examples.

%prep
%setup -q -n jde
%patch -p1

%build
export CLASSPATH=/usr/share/java/ant-contrib.jar
CEDETDIR=%_emacslispdir/cedet
[ -d $CEDETDIR ] || CEDETDIR=$(sh -c echo /usr/share/emacs/*/lisp/cedet)
ant -Delib.dir=%_emacslispdir/elib -Dcedet.dir=$CEDETDIR


%install
mkdir -p %buildroot%_emacslispdir/jde/java/classes

install -m 644 build/lisp/*.el* %buildroot%_emacslispdir/jde
cp -R java/bsh-commands java/lib %buildroot%_emacslispdir/jde/java
touch %buildroot%_emacslispdir/jde/java/.nosearch

mkdir -p %buildroot%_bindir
install -m 755 lisp/jtags %buildroot%_bindir

mkdir -p %buildroot%_emacs_sitestart_dir
install -m 644 %SOURCE1 %buildroot%_emacs_sitestart_dir/23jde.el

%files
%doc doc
%dir %_emacslispdir/jde/
%_emacslispdir/jde/*.elc
%dir %_emacslispdir/jde/java/
%_emacslispdir/jde/java/*
%_emacslispdir/jde/java/.nosearch
%_bindir/*
%config(noreplace) %_emacs_sitestart_dir/23jde.el

%files el
%_emacslispdir/jde/*.el

%changelog
