%define ver_major 0.21
%define beta %nil
# since 0.20.4 requires ecore_wl2 available in efl >= 1.17
%define efl_ver_major 1.18
%define snapshot 2015-10-28
%define cvs_date 5469c3b6
%undefine cvs_date
%define rel alt0.M80P.1

%def_disable static
# only bluez4 supported
%def_disable bluetooth
%def_enable wayland
%def_enable xwayland
%def_enable wl_drm
%def_enable wl_x11
%def_enable systemd
%def_enable install_sysactions
%def_with pam_helper

Name: enlightenment
Version: %ver_major.11

%ifdef cvs_date
Release: %rel.%cvs_date
%else
Release: %rel
%endif
Epoch: 1

Summary: The Enlightenment window manager
License: BSD
Group: Graphical desktop/Enlightenment
URL: http://www.enlightenment.org/

%ifdef cvs_date
Source: %name-%version-%cvs_date.tar
%else
Source: https://download.enlightenment.org/rel/apps/%name/%name-%version%beta.tar.xz
%endif

Source1: E.png
Source2: start_%name
Source3: %name.wmsession
Source8: %name.desktop
%{?_enable_install_sysactions:Source11: %name-alt-sysactions.conf}

Patch0: fix-systray-height.patch
Patch1: add-systray-mobile.patch
Patch2: add-systray-standard.patch
Patch3: illume-keyboard-bigfont.patch
Patch4: e17-0.17.0-alt-g-s-d_path.patch
Patch5: enlightenment-0.19.99-alt-e_sys_nosuid.patch
Patch6: auto-ptrace-disable.patch
Patch11: enlightenment-0.19.0-alt-pam-helper.patch
Patch12: fix-connman-module-detection.patch

Provides: e19 = %EVR
# Obsoletes/Provides old eNN
Obsoletes: e17 e18
Provides: e17 = %EVR
Provides: e18 = %EVR
Provides: %name-default
Obsoletes: e17-default e18-default
Provides: e17-default = %EVR
Provides: e18-default = %EVR

# default terminal
Requires: terminology
# default image viewer
Requires: ephoto
# default media player
Requires: rage
# for menu
Requires: gnome-icon-theme
Requires: wm-common-freedesktop
Requires: altlinux-freedesktop-menu-%name >= 0.55
Requires: udisks2
Requires: pulseaudio-daemon
Requires: geoclue2
%{?_with_pam_helper:Requires: chkpwd-pam}

BuildRequires: rpm-build-xdg
BuildRequires: efl-libs-devel >= %efl_ver_major libelementary-devel >= %efl_ver_major
BuildRequires: libpam-devel libalsa-devel libudev-devel libxcbutil-keysyms-devel
BuildRequires: libdbus-devel libp11-kit-devel xorg-xproto-devel libxcbutil-keysyms-devel
BuildRequires: libuuid-devel libpulseaudio-devel
BuildRequires: libxkbcommon-devel libdrm-devel libgbm-devel
BuildRequires: doxygen
# for sysv
BuildRequires: pm-utils
%{?_enable_bluetooth:BuildRequires: libbluez-devel}
%{?_enable_wayland:BuildRequires: libwayland-server-devel >= 1.3.0 libpixman-devel libEGL-devel libwayland-egl-devel}
%{?_enable_systemd:BuildRequires: systemd-devel}

%description
Enlightenment is a window manager.

%package devel
Summary: Development headers for Enlightenment.
Group: Development/C
Requires: %name = %EVR
# Obsoletes/Provides old eNN
Obsoletes: e17-devel e18-devel
Provides: e17-devel = %EVR
Provides: e18-devel = %EVR

%description devel
Development headers for Enlightenment.

%prep
%ifdef cvs_date
%setup -n %name-%version-%cvs_date
%else
%setup -n %name-%version%beta
%endif
#%%patch0 -p2
#%patch1 -p2
#%patch2 -p2
#%patch3 -p2
%patch4 -p1 -b .gsd
%patch5 -p1 -b .nosuid
%patch6 -p2 -b .ptrace
%if_with pam_helper
%patch11 -p1 -b .pam_helper
%endif
#%patch12 -p2

%build
%autoreconf
export CFLAGS="$CFLAGS `pkg-config --cflags dbus-1` `pkg-config --cflags uuid` -g -ggdb3"
%configure \
	--with-profile=FAST_PC \
	--enable-files \
	%{subst_enable static} \
	--enable-shared \
	--enable-pam \
	%{subst_enable wayland} \
	%{?_enable_xwayland:--enable-xwayland --with-Xwayland=%_bindir/Xwayland} \
	%{?_enable_wl_drm:--enable-wl-drm} \
	%{?_enable_wl_x11:--enable-wl-x11} \
	%{?_disable_install_sysactions:--disable-install-sysactions} \
%if_with pam_helper
	--with-pam-helper=%prefix/libexec/chkpwd-pam/chkpwd-pam \
%endif

%make_build
%make doc

%install
%makeinstall_std

mkdir -p %buildroot%_rpmmacrosdir
cat > %buildroot%_rpmmacrosdir/%name <<_EOF_
%%enlightenment_version		%version
_EOF_

mkdir -p %buildroot%_sysconfdir/X11/wmsession.d
mkdir -p %buildroot%_bindir/
install -p -m755 %SOURCE2 %buildroot%_bindir/
install -D -pm 644 %SOURCE3 %buildroot%_sysconfdir/X11/wmsession.d/05Enlightenment

# Install icon
install -pD -m644 %SOURCE1 %buildroot%_liconsdir/E-18.png

# desktop file
install -pD -m 644 %SOURCE8 %buildroot%_datadir/applications/%name.desktop

# PAM-config
mkdir -p %buildroot%_sysconfdir/pam.d
cat > %buildroot%_sysconfdir/pam.d/%name << _PAM_
#%%PAM-1.0

auth		include		system-auth
account		required	pam_deny.so
password	required	pam_deny.so
session		required	pam_deny.so
_PAM_

# replace original sysaction.conf
cp %SOURCE11 %buildroot%_sysconfdir/%name/sysactions.conf

# replace original menus by symlink to our enlightenment.menu
ln -sf %name.menu %buildroot/%_xdgmenusdir/e-applications.menu

%find_lang %name

%files -f %name.lang
%config %_sysconfdir/X11/wmsession.d/*
%config %_sysconfdir/%name/sysactions.conf
%config(noreplace) %_sysconfdir/pam.d/%name
%dir %_libdir/%name/
%_libdir/%name/*
%_liconsdir/*.png
%_bindir/*
%_datadir/%name/
#!
%_datadir/pixmaps/emixer.png
%_datadir/xsessions/%name.desktop
%_datadir/applications/*.desktop
%{?_enable_systemd:%_prefix/lib/systemd/user/%name.service}
%_xdgmenusdir/e-applications.menu
%doc AUTHORS COPYING README

%exclude %_libdir/%name/modules/*/*/*.la

%files devel
%_includedir/%name/
%_pkgconfigdir/%name.pc
%_pkgconfigdir/everything.pc
%_rpmmacrosdir/%name

%changelog
