Name: enscript
Version: 1.6.6
Release: alt1.1

Summary: Converts plain ASCII to PostScript
License: GPL
Group: Publishing
Url: http://www.gnu.org/software/enscript/

Source0: %name-%version.tar.gz
Source1: repatch_spec.sh
Source2: repatch_spec.unused

## FC patches
Patch1: FC-1.6.1-locale.patch
Patch2: FC-wrap_header.patch
Patch3: FC-1.6.4-rh457720.patch
Patch4: FC-rh477382.patch
Patch5: FC-build.patch
Patch6: FC-manfixes.patch
Patch7: FC-bufpos-crash.patch

## Ubuntu patches
Patch101: Ubuntu-01_libpaper.patch
Patch102: Ubuntu-03_misc.patch
Patch103: Ubuntu-04_highlighting.patch
Patch104: Ubuntu-339938-hilight-wrapped-function-list.patch
Patch105: Ubuntu-06_debian.patch
Patch106: Ubuntu-07_media.patch
Patch107: Ubuntu-09_appendctrld.patch
Patch108: Ubuntu-344750-no-gecos.patch
Patch109: Ubuntu-147116-ruby-hilight.patch
Patch110: Ubuntu-457244-octave-highlighting.patch

## ALT patches
Patch501: enscript-1.6.4-alt-mail.patch
Patch502: enscript-1.6.3-alt-fontpath.patch
Patch503: enscript-1.6.3-alt-default-enc.patch
Patch504: enscript-1.6.3-alt-encodings.patch

# Automatically added by buildreq on Thu May 29 2014
# optimized out: xz
BuildRequires: flex libpaper-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Enscript is a print filter. It can take ASCII input
and format it into PostScript output. At the same time,
it can also do nice transformations like putting two
ASCII pages on one physical page (side by side) or
changing fonts.

%prep
%setup

## FC apply patches
%patch1 -p1 -b .locale
%patch2 -p1 -b .wrap_header
%patch3 -p1 -b .rh457720
%patch4 -p1 -b .rh477382
%patch5 -p1 -b .build
%patch6 -p1 -b .manfixes
%patch7 -p1 -b .bufpos-crash

## Ubuntu apply patches
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
%patch105 -p1
%patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
%patch110 -p1

## ALT apply patches
%patch501 -p1
%patch502 -p1
%patch503 -p1
%patch504 -p1

%build
export CPPFLAGS='-DPROTOTYPES'
%autoreconf
%configure --with-media=A4
%make_build

%install
%makeinstall

install -pm755 -d $RPM_BUILD_ROOT%_sysconfdir/%name
install -pm644 $RPM_BUILD_ROOT/%_datadir/%name/afm/font.map $RPM_BUILD_ROOT%_sysconfdir/%name/font.map
cd $RPM_BUILD_ROOT/%_datadir/%name
ln -s  %_sysconfdir/%name/font.map
cd -

%find_lang %name

ln -s %_bindir/enscript $RPM_BUILD_ROOT%_bindir/nenscript

%files -f %name.lang
%doc AUTHORS ChangeLog NEWS README README.ESCAPES THANKS TODO
%config(noreplace) %_sysconfdir/enscript.cfg
%config(noreplace) %_sysconfdir/enscript/font.map
%_bindir/*
%_mandir/man?/*
%_datadir/%name
%_infodir/*.info*

%changelog
