%def_disable snapshot
%define ver_major 3.24
%define api_ver 3.10
%define ua_ver 3.24
%define xdg_name org.gnome.Epiphany

%define _libexecdir %_prefix/libexec

%def_without libhttpseverywhere

Name: epiphany
Version: %ver_major.5
Release: alt0.M80P.2

Summary: Epiphany is a GNOME web browser.
Summary(ru_RU.UTF-8): Epiphany - интернет-браузер для графической оболочки GNOME.
Group: Networking/WWW
License: GPL
URL: http://www.gnome.org/projects/%name

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif
Patch: %name-3.17.2-alt-lfs.patch

Provides: webclient
Obsoletes: %name-extensions

%define webkit_ver 2.15.91
%define gtk_ver 3.22.13
%define libxml2_ver 2.6.12
%define xslt_ver 1.1.7
%define soup_ver 2.48.0
%define secret_ver 0.14
%define gcr_ver 3.5.5

Requires: %name-data = %version-%release indexhtml iso-codes

BuildRequires: gnome-common yelp-tools libappstream-glib-devel
BuildPreReq: intltool >= 0.50.0
BuildPreReq: libgio-devel
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libSM-devel
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: libxslt-devel >= %xslt_ver
BuildPreReq: libwebkit2gtk-devel >= %webkit_ver
BuildPreReq: libsoup-devel >= %soup_ver
BuildPreReq: libsecret-devel >= %secret_ver
BuildPreReq: gcr-libs-devel >= %gcr_ver
BuildRequires: libwnck3-devel libgnome-desktop3-devel libnotify-devel libnss-devel libsqlite3-devel
BuildPreReq: iso-codes-devel >= 0.35
BuildRequires: gcc-c++ gsettings-desktop-schemas-devel
# Zeroconf support
BuildPreReq: libavahi-devel libavahi-gobject-devel
# since 3.23.x
%{?_with_libhttpseverywhere:BuildPreReq: libhttpseverywhere-devel >= 0.2.2}
BuildRequires: libicu-devel libjson-glib-devel

%description
Epiphany is a GNOME web browser based on the Webkit rendering engine.
%description -l ru_RU.UTF8
Epiphany - интернет-браузер для графической
оболочки GNOME, основанный на движке
отрисовки страниц Webkit.

%package data
Summary: Epiphany data files
Group: Networking/WWW
BuildArch: noarch

%description data
Epiphany is a GNOME web browser based on the Webkit rendering engine.
This package contains common noarch files needed for Epiphany.

%prep
%setup
%patch -p1
# libtool-2.4.6 required
rm -rf build-aux aclocal.m4 /m4/libtool.m4 m4/lt*.m4

%build
%autoreconf
%configure \
	--disable-schemas-compile \
	--disable-dependency-tracking \
	--with-distributor-name="ALTLinux" \
	%{subst_with libhttpseverywhere}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang %name %name-2.0

%files
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/ephy-profile-migrator
%_libexecdir/%name-search-provider
%dir %_libdir/%name
%_libdir/%name/*.so
%dir %_libdir/%name/web-extensions
%_libdir/%name/web-extensions/libephywebextension.so
%exclude %_libdir/%name/*.la
%exclude %_libdir/%name/web-extensions/libephywebextension.la
%doc AUTHORS NEWS README TODO

%files data -f %name.lang
%_desktopdir/%xdg_name.desktop
%_datadir/%name
%_datadir/dbus-1/services/*
%config %_datadir/glib-2.0/schemas/org.gnome.epiphany.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.Epiphany.enums.xml
%_man1dir/*
%_datadir/gnome-shell/search-providers/epiphany-search-provider.ini
%_iconsdir/hicolor/*x*/apps/%xdg_name.png
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/appdata/%xdg_name.appdata.xml

%changelog
