%def_disable iso
%def_disable liso
%def_enable zdsk
%def_enable zlilo
%def_enable zpxe
%def_enable zrom
%def_with contrib

%define formats %{?_enable_iso: iso}%{?_enable_liso: liso}%{?_enable_zdsk: zdsk}%{?_enable_zlilo: zlilo}%{?_enable_zpxe: zpxe}%{?_enable_zrom: zrom}

%define Name Etherboot
Name: etherboot
Version: 5.4.3
Release: alt4
Summary: Boot ROM images for ethernet adapters
License: %gpl2plus
Group: Networking/Other
Url: http://%name.sourceforge.net
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: %name-%version-forcedeth.patch
Packager: Led <led@altlinux.ru>
ExclusiveArch: %ix86

BuildRequires(pre): rpm-build-licenses
%{?_enable_iso:BuildRequires: mkisofs}
%{?_enable_liso:BuildRequires: mkisofs mtools syslinux}

%description
%Name is a software package for creating ROM images that can
download code over an Ethernet network to be executed on an x86
computer. Many network adapters have a socket where a ROM chip can be
installed. %Name is code that can be put in such a ROM. %Name
is normally used for for booting PCs diskless.


%if_enabled iso
%package iso
Summary: %Name iso images
Group: Networking/Other

%description iso
%Name iso images.
%endif


%if_enabled zrom
%package zrom
Summary: %Name zrom images
Group: Networking/Other

%description zrom
%Name zrom images.
%endif


%if_with contrib
%package contrib
Summary: Some %name tools
Group: Networking/Other
AutoReq: no

%description contrib
Some programs to work with %name ROM images.
%endif


%prep
%setup
%patch0 -p1
%patch1 -p1
subst 's/\r$//' contrib/{wakeonlan/{readme.txt,wakeup.pl,mp-form*},hdload/hdload.S}
subst '1 s|^#!/perl/|#!/usr/|' contrib/wakeonlan/mp-form.pl
subst 's/-mcpu=/-mtune=/g' src/arch/i386/Config


%build
%define _optlevel s
%add_optflags -fno-stack-protector
echo CFLAGS+="%optflags" >> src/Config
# we don't use custom optimizations here because it can cause problems;
# parallel make not SMP-friendly
for f in %formats; do
    # can compile undi.c ONLY with -O1 (on gcc 4.3)
    %make -C src UNDIFLAGS="-O1" all${f}s
done
ln -s {index,about}.html
bzip2 --best --keep --force LOG


%install
install -d -m 0755 %buildroot%_libexecdir/%name
install -m 0755 src/util/*rom.pl %buildroot%_libexecdir/%name
for f in %formats; do
    install -d -m 0755 %buildroot%_datadir/%name/$f
    install -m 0644 src/bin/*.$f %buildroot%_datadir/%name/$f/
done

%if_with contrib
find contrib -type f \! -name '.*' -print |
while read F; do
    if [ -x "$F" -o $(basename "$F") != $(basename "$F" .pl) -o $(basename "$F") != $(basename "$F" .sh) ]; then
	install -pD -m 0755 "$F" %buildroot%_datadir/%name/"$F"
    else
	install -pD -m 0644 "$F" %buildroot%_datadir/%name/"$F"
    fi
done
%endif


%files
%doc Copyrights LOG.* RELNOTES about.html eb.png style.css
%_libexecdir/%name
%dir %_datadir/%name
%{?_enable_zdsk:%_datadir/%name/zdsk}
%{?_enable_zlilo:%_datadir/%name/zlilo}
%{?_enable_zpxe:%_datadir/%name/zpxe}
%exclude %_datadir/%name/contrib


%if %enabled iso || %enabled liso
%files iso
%dir %_datadir/%name
%{?_enable_iso:%_datadir/%name/iso}
%{?_enable_liso:%_datadir/%name/liso}
%endif


%if_enabled zrom
%files zrom
%dir %_datadir/%name
%_datadir/%name/zrom
%endif


%if_with contrib
%files contrib
%dir %_datadir/%name
%_datadir/%name/contrib
%endif


%changelog
