%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 3.24
%define api_ver 3
%define so_ver 4

%def_enable xps
%def_enable introspection
%def_enable browser_plugin
%def_enable multimedia

Name: evince
Version: %ver_major.2
Release: alt0.M80P.1

Summary: A document viewer
Group: Office
License: GPL
Url: http://www.gnome.org/projects/evince/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: lib%name = %version-%release
Requires: gnome-icon-theme gnome-icon-theme-symbolic icon-theme-adwaita
Requires: gvfs-backend-recent-files
Requires: dconf
%{?_enable_multimedia:Requires: gst-plugins-base1.0 gst-libav}

%define poppler_ver 0.24.0
%define gtk_ver 3.16.0

BuildPreReq: libpoppler-glib-devel >= %poppler_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildRequires: gcc-c++ gnome-common gtk-doc
BuildRequires: intltool yelp-tools itstool
BuildRequires: icon-theme-adwaita libdjvu-devel libgnome-keyring-devel libnautilus-devel  libspectre-devel libtiff-devel
BuildRequires: libxml2-devel libkpathsea-devel libgail3-devel gsettings-desktop-schemas-devel zlib-devel libsecret-devel
BuildRequires: libarchive-devel
BuildRequires: libgnome-desktop3-devel
%{?_enable_xps:BuildRequires: libgxps-devel}
%{?_enable_browser_plugin:BuildRequires:browser-plugins-npapi-devel}
%{?_enable_multimedia:BuildRequires: gst-plugins1.0-devel}
BuildRequires: libXi-devel
BuildRequires: systemd-devel

%if_enabled introspection
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
%endif

%description
Evince is a document viewer capable of displaying multiple and single page
document formats like PDF and Postscript

%package dvi
Summary: Evince backend for dvi files
Group: Office
Requires: %name = %version-%release

%description dvi
A backend to let evince display dvi files

%package -n lib%name
Summary: Library for the %name project
Group: Office

%description -n lib%name
Library for %name project

%package -n lib%name-gir
Summary: GObject introspection data for the Evince library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Evince library

%package -n lib%name-devel
Summary: Development tools for the %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Header files for %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Evince library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Evince library

%package -n mozilla-plugin-%name
Summary: Mozilla plugin for the Evince document viewer
Group: Networking/WWW
Requires: %name = %version-%release
Requires: browser-plugins-npapi

%description -n mozilla-plugin-%name
A Mozilla plug-in that enables to view documents from within webpages
via the Evince.

%prep
%setup

[ ! -d m4 ] && mkdir m4

%build
export BROWSER_PLUGIN_DIR=%browser_plugins_path
%autoreconf
%configure \
	--disable-schemas-compile \
	--enable-pdf \
	--enable-tiff \
	--enable-djvu \
	--enable-dvi \
	--enable-comics \
	--enable-gtk-doc \
	--enable-nautilus \
	--enable-dbus \
	%{subst_enable xps} \
	%{subst_enable introspection} \
	%{?_enable_browser_plugin:--enable-browser-plugin} \
	%{subst_enable multimedia} \
	--disable-static
%make_build

%install
%makeinstall_std

subst '/NoDisplay/d' %buildroot%_desktopdir/%name.desktop

%find_lang %name --with-gnome

%files -f %name.lang
%doc AUTHORS NEWS README
%_bindir/evince*
%_prefix/lib/systemd/user/%name.service
%_libdir/nautilus/extensions-3.0/libevince-properties-page.so
%dir %_libdir/evince
%dir %_libdir/evince/%so_ver
%dir %_libdir/evince/%so_ver/backends
%_libdir/evince/%so_ver/backends/libcomicsdocument.so
%_libdir/evince/%so_ver/backends/libdjvudocument.so
%_libdir/evince/%so_ver/backends/libpdfdocument.so
%_libdir/evince/%so_ver/backends/libpsdocument.so
%_libdir/evince/%so_ver/backends/libtiffdocument.so
%{?_enable_xps:%_libdir/evince/%so_ver/backends/libxpsdocument.so}
%_libdir/evince/%so_ver/backends/*.evince-backend
%exclude %_libdir/evince/%so_ver/backends/dvidocument.evince-backend
%_libexecdir/evince*
%_desktopdir/%name.desktop
%_desktopdir/%name-previewer.desktop
%_datadir/appdata/%name-comicsdocument.metainfo.xml
%_datadir/appdata/%name-djvudocument.metainfo.xml
%_datadir/appdata/%name-pdfdocument.metainfo.xml
%_datadir/appdata/%name-psdocument.metainfo.xml
%_datadir/appdata/%name-tiffdocument.metainfo.xml
%_datadir/appdata/%name-xpsdocument.metainfo.xml
%_datadir/appdata/%name.appdata.xml

%_datadir/dbus-1/services/org.gnome.evince.Daemon.service
%_datadir/%name/
%_datadir/GConf/gsettings/evince.convert
%_datadir/glib-2.0/schemas/org.gnome.Evince.gschema.xml
%_datadir/thumbnailers/evince.thumbnailer
%_iconsdir/hicolor/*/apps/*
%_man1dir/*.1*

%files -n lib%name
%_libdir/libevdocument%{api_ver}.so.%{so_ver}*
%_libdir/libevview%{api_ver}.so.3*

%files dvi
%_libdir/evince/%so_ver/backends/dvidocument.evince-backend
%_libdir/evince/%so_ver/backends/libdvidocument.so
%_datadir/appdata/%name-dvidocument.metainfo.xml

%files -n lib%name-devel
%_includedir/evince
%_libdir/libevdocument%{api_ver}.so
%_libdir/libevview%{api_ver}.so
%_pkgconfigdir/*.pc
%_datadir/gtk-doc/html/%name
%_datadir/gtk-doc/html/libev*

%if_enabled introspection
%files -n lib%name-gir
%_libdir/girepository-1.0/EvinceDocument-3.0.typelib
%_libdir/girepository-1.0/EvinceView-3.0.typelib

%files -n lib%name-gir-devel
%_datadir/gir-1.0/EvinceDocument-3.0.gir
%_datadir/gir-1.0/EvinceView-3.0.gir
%endif

%if_enabled browser_plugin
%files -n mozilla-plugin-%name
%browser_plugins_path/libevbrowserplugin.so
%endif

%exclude %browser_plugins_path/libevbrowserplugin.la
%exclude %_libdir/%name/%so_ver/backends/*.la
%exclude %_libdir/nautilus/extensions-3.0/libevince-properties-page.la

%changelog
