%def_disable snapshot
# since 3.13.6
# see https://git.gnome.org/browse/evolution-data-server/commit/?id=a2790163af4d3f375a778055d0e2699207dfd050
%set_verify_elf_method unresolved=relaxed
%set_verify_elf_method rpath=relaxed

%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec

%define ver_major 3.24
%define ver_base 3.24
%define ver_lib 1.2

%def_disable debug
%def_disable static
%def_with libdb
%def_with openldap
%def_without static_ldap
%def_with krb5
%def_enable goa
%def_enable google
# Ubuntu online accounts support
%def_disable uoa
%{?_enable_snapshot:%def_enable gtk_doc}
%def_enable gtk_doc
%def_enable introspection
%def_enable vala
%def_enable installed_tests

Name: evolution-data-server
Version: %ver_major.7
Release: alt0.M80P.1

Summary: Evolution Data Server
License: %lgpl2plus
Group: Graphical desktop/GNOME
URL: https://wiki.gnome.org/Apps/Evolution

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%endif
Patch1: %name-1.4.2.1-debug-lock.patch

%add_findprov_lib_path %_libdir/%name

# from configure.ac
%define glib_ver 2.40.0
%define gtk3_ver 3.10.0
%define libsoup_ver 2.42
%define gcr_ver 3.4
%define secret_ver 0.5
%define sqlite_ver 3.7.17
%define gweather_ver 3.10.0
%define ical_ver 0.43
%define gdata_ver 0.15.1
%define goa_ver 3.8.0
%define vala_ver 0.13.1
%define webkit_ver 2.13.0

Requires: dconf

BuildRequires: cmake gcc-c++ rpm-build-gnome rpm-build-licenses intltool
BuildRequires: gtk-doc >= 1.0
BuildRequires: gnome-common
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk3_ver
BuildRequires: libxml2-devel
BuildRequires: libsoup-devel >= %libsoup_ver
BuildRequires: libsqlite3-devel >= %sqlite_ver
BuildRequires: libgweather-devel >= %gweather_ver
BuildRequires: libical-devel >= %ical_ver
BuildRequires: libgdata-devel >= %gdata_ver
BuildRequires: libsecret-devel >= %secret_ver
BuildRequires: gcr-libs-devel >= %gcr_ver
BuildRequires: gperf docbook-utils flex bison libcom_err-devel libnss-devel libnspr-devel zlib-devel libicu-devel
%{?_enable_goa:BuildRequires: libgnome-online-accounts-devel >= %goa_ver liboauth-devel libgdata-devel >= %gdata_ver}
%{?_enable_google:BuildRequires: libwebkit2gtk-devel >= %webkit_ver libjson-glib-devel}
%{?_enable_uoa:BuildRequires: libaccounts-glib-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libsoup-gir-devel libgtk+3-gir-devel}
%{?_with_libdb:BuildRequires: libdb4-devel}
%{?_with_krb5:BuildRequires: libkrb5-devel}
%{?_enable_vala:BuildRequires: vala >= %vala_ver vala-tools >= %vala_ver}

# /usr/libexec/evolution-data-server/csv2vcard uses perl(diagnostics.pm)
BuildRequires: perl-devel

%if_with openldap
BuildRequires: libldap-devel
%if_with static_ldap
BuildRequires: libldap-devel-static libssl-devel libsasl2-devel
%endif
%endif

%description
Evolution Data Server provides a central location for
addressbook and calendar in the GNOME Desktop.

%package devel
Summary: Development files for Evolution Data Server
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides development files for Evolution Data Server

%package devel-doc
Summary: Development documentation for Evolution Data Server
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
Evolution Data Server provides a central location for
addressbook and calendar in the GNOME Desktop.

This package contains development documentation for Evolution Data Server.

%package gir
Summary: GObject introspection data for the EDS
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Evolution Data Server libraries

%package gir-devel
Summary: GObject introspection devel data for the EDS
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Evolution Data Server libraries

%package vala
Summary: Vala language bindings for the EDS libraries
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description vala
This package provides Vala language bindings for the EDS libraries

%package tests
Summary: Tests for the EDS
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed EDS libraries.


%prep
%setup
%if_enabled debug
%patch1 -p1
%endif

%build
# reenable RPATH* to link against private libraries
%cmake \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
	-DCMAKE_SKIP_RPATH:BOOL=OFF \
	-DCMAKE_BUILD_WITH_INSTALL_RPATH:BOOL=ON \
	-DCAMEL_LOCK_HELPER_GROUP:STRING=mail \
	-DSENDMAIL_PATH:STRING=%_sbindir/sendmail \
	-DENABLE_FILE_LOCKING:STRING=fcntl \
	-DENABLE_DOT_LOCKING:BOOL=OFF \
	-DENABLE_SCHEMAS_COMPILE:BOOL=OFF \
	-DENABLE_SMIME:BOOL=ON \
	%{?_with_libdb:-DWITH_LIBDB:BOOL=ON} \
	%{?_with_openldap:-DWITH_OPENLDAP:BOOL=ON} \
	%{?_with_static_ldap:-DWITH_STATIC_LDAP:BOOL=ON} \
	%{?_with_krb5:-DWITH_KRB5:BOOL=ON} \
	%{?_enable_goa:-DENABLE_GOA:BOOL=ON} \
	%{?_disable_google:-DENABLE_GOOGLE_AUTH:BOOL=OFF} \
	%{?_disable_uoa:-DENABLE_UOA:BOOL=OFF} \
	%{?_enable_introspection:-DENABLE_INTROSPECTION:BOOL=ON} \
	%{?_enable_gtk_doc:-DENABLE_GTK_DOC:BOOL=ON} \
	%{?_enable_vala:-DENABLE_VALA_BINDINGS:BOOL=ON} \
	%{?_enable_installed_tests:-DENABLE_INSTALLED_TESTS:BOOL=ON}
%cmake_build

%install
%cmakeinstall_std
# if unstable
ln -s camel-lock-helper-1.2 %buildroot%_libexecdir/camel-lock-helper
# temporarily symlink for %_libdir/%name/libedbus-private.so in %_libdir to link evolution-3.23.90
#ln -s %name/libedbus-private.so %buildroot%_libdir/libedbus-private.so

%find_lang --with-gnome --output=%name.lang %name-%ver_base

%files -f %name.lang
%_libexecdir/*
%{?_enable_installed_tests:%exclude %_libexecdir/%name/installed-tests/}
%dir %_libdir/%name/addressbook-backends
%dir %_libdir/%name/calendar-backends
%dir %_libdir/%name/camel-providers
%_libdir/%name/*/*.so
%_libdir/%name/*/*.urls
%_libdir/*.so.*
%_libdir/%name/libedbus-private.so
# symlink to private library
#%_libdir/libedbus-private.so
%_datadir/%name/
%_datadir/dbus-1/services/*
%_prefix/lib/systemd/user/evolution-addressbook-factory.service
%_prefix/lib/systemd/user/evolution-calendar-factory.service
%_prefix/lib/systemd/user/evolution-source-registry.service
%_prefix/lib/systemd/user/evolution-user-prompter.service

%_datadir/pixmaps/*
%_datadir/GConf/gsettings/evolution-data-server.convert
%_datadir/glib-2.0/schemas/org.gnome.evolution-data-server.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.Evolution.DefaultSources.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution-data-server.addressbook.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution-data-server.calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.eds-shell.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.shell.network-config.gschema.xml
%doc AUTHORS NEWS README MAINTAINERS

%files devel
%_includedir/*
%_libdir/*.so
# symlink to private library
#%exclude %_libdir/libedbus-private.so
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files devel-doc
%_gtk_docdir/*
%endif

%if_enabled introspection
%files gir
#%_typelibdir/ECalendar-%ver_lib.typelib
%_typelibdir/Camel-%ver_lib.typelib
%_typelibdir/EBookContacts-%ver_lib.typelib
%_typelibdir/EDataServer-%ver_lib.typelib
%_typelibdir/EDataServerUI-%ver_lib.typelib
%_typelibdir/EBook-%ver_lib.typelib

%files gir-devel
#%_girdir/ECalendar-%ver_lib.gir
%_girdir/Camel-%ver_lib.gir
%_girdir/EBookContacts-%ver_lib.gir
%_girdir/EDataServer-%ver_lib.gir
%_girdir/EDataServerUI-%ver_lib.gir
%_girdir/EBook-%ver_lib.gir
%endif

%if_enabled vala
%files vala
%_datadir/vala/vapi/*.deps
%_datadir/vala/vapi/*.vapi
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/%name/installed-tests/
%_datadir/installed-tests/%name/
%endif

%changelog
