%set_verify_elf_method rpath=relaxed
%define ver_major 3.24

Name: evolution-ews
Version: %ver_major.6
Release: alt0.M80P.1

Group: Networking/Mail
Summary: Evolution extension for Exchange Web Services
License: LGPLv2
Url: https://wiki.gnome.org/Apps/Evolution

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define ver_base 3.24
%define evo_ver_base %ver_base

%define evolution_ver 3.24.6
# from configure.ac
%define eds_ver 3.24.7
%define glib_ver 2.40
%define libmspack_ver 0.4
%define soup_ver 2.42

Requires: evolution >= %evolution_ver
Requires: evolution-data-server >= %eds_ver
Requires: libmspack >= %libmspack_ver

BuildRequires: cmake gcc-c++ intltool
BuildRequires: gnome-common rpm-build-gnome gtk-doc
BuildRequires: evolution-data-server-devel >= %eds_ver
BuildRequires: evolution-devel >= %evolution_ver
BuildRequires: libmspack-devel >= %libmspack_ver
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= 3.0
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: libsqlite3-devel libical-devel

# following unusual reqs needed to link against evolution >= 3.13.6 libraries
BuildRequires: libchamplain-gtk3-devel libgail3-devel gcr-libs-devel libp11-kit-devel
BuildRequires: libgnome-desktop3-devel libdbus-devel libdbus-glib-devel libgeocode-glib-devel
BuildRequires: libgeoclue-devel libgtkspell3-devel libgnome-autoar-devel
BuildRequires: libcanberra-gtk3-devel libcryptui-devel

%description
This package allows Evolution to interact with Microsoft Exchange servers,
versions 2007 and later, through its Exchange Web Services (EWS) interface.

%prep
%setup

%build
# reenable RPATH* to link against private libraries
%cmake \
	-DCMAKE_SKIP_RPATH:BOOL=OFF \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
	-DCMAKE_BUILD_WITH_INSTALL_RPATH:BOOL=ON
%cmake_build

%install
%cmakeinstall_std

# Remove files we don't want packaged (no devel subpackage).
rm -rf %buildroot%_includedir/evolution-data-server
find %buildroot%_libdir -name '*.la' -exec rm {} \;
rm -f %buildroot%_libdir/evolution-data-server/*.so

%find_lang %name

%files -f %name.lang
%doc COPYING NEWS README
%_libdir/%name/*.so
%_libdir/evolution-data-server/camel-providers/*
%_libdir/evolution-data-server/addressbook-backends/*.so
%_libdir/evolution-data-server/calendar-backends/*.so
%_libdir/evolution-data-server/registry-modules/*.so
%_libdir/evolution/modules/*.so
%_datadir/evolution/errors/*.error
%_datadir/evolution-data-server/ews/windowsZones.xml
%_datadir/appdata/evolution-ews.metainfo.xml

%changelog
