Name: exaile
Version: 3.4.5
Release: alt1

Summary: a music player aiming to be similar to KDE's Amarok, but for GTK+ and written in Python
License: GPL
Group: Sound
Url: http://www.exaile.org

BuildArch: noarch
Source: https://github.com/exaile/%name/releases/download/%version/%name-%version.tar.gz
Patch0: %name-%version-%release.patch

%add_python_req_skip xl
%add_python_req_skip xlgui

BuildRequires: help2man python-module-pygobject python-devel

Requires: gst-plugins-base

%description
Exaile is a music player aiming to be similar to KDE's Amarok, but for
GTK+ and written in Python. It incorporates many of the cool things from
Amarok (and other media players) like automatic fetching of album art,
handling of large libraries, lyrics fetching, artist/album information
via Wikipedia, Last.fm submission support, and optional iPod support via
a plugin.
In addition, Exaile also includes a built-in SHOUTcast directory
browser, tabbed playlists (so you can have more than one playlist open
at a time), blacklisting of tracks (so they don't get scanned into your
library), downloading of guitar tablature from fretplay.com, and
submitting played tracks on your iPod to Last.fm.

%package plugin-ipod
Group: Sound
Summary: Ipod plugin for exaile
Requires: %name = %version-%release

%description plugin-ipod
%summary

%package plugin-exfalso
Group: Sound
Summary: Ex Falso tag editor for exaile
Requires: %name = %version-%release

%description plugin-exfalso
%summary

%prep
%setup -q
%patch -p1

%build
%make_build

%install
%make_install DESTDIR=%buildroot PREFIX=%_prefix install
mkdir -p %buildroot{%_liconsdir,%_niconsdir,%_miconsdir}
cp %buildroot%_datadir/%name/data/images/16x16/%name.png %buildroot%_miconsdir/
cp %buildroot%_datadir/%name/data/images/32x32/%name.png %buildroot%_niconsdir/
cp %buildroot%_datadir/%name/data/images/48x48/%name.png %buildroot%_liconsdir/

%find_lang %name

%files -f %name.lang
%_sysconfdir/xdg/%name
%_bindir/%name
%_desktopdir/%name.desktop
%_prefix/lib/%name
%exclude %_datadir/%name/plugins/ipod
%exclude %_datadir/%name/plugins/exfalso
%_datadir/%name
%_datadir/appdata/exaile.appdata.xml
%_datadir/dbus-1/services/org.exaile.Exaile.service
%_liconsdir/%name.png
%_niconsdir/%name.png
%_miconsdir/%name.png
%_man1dir/%name.*
%doc COPYING

%files plugin-ipod
%_datadir/%name/plugins/ipod

%files plugin-exfalso
%_datadir/%name/plugins/exfalso

%changelog
