%def_enable video
%def_enable webready

Name: exiv2
Version: 0.25
Release: alt1

Summary: Command line tool to access EXIF data in image files
License: GPLv2+
Group: Graphics

Url: http://www.exiv2.org
Source: %url/exiv2-%version.tar.gz
Patch: %name-0.23-alt-lfs.patch

Requires: libexiv2 = %version-%release

BuildRequires: gcc-c++ libexpat-devel zlib-devel
BuildRequires: doxygen xsltproc graphviz
%{?_enable_webready:BuildRequires: libcurl-devel libssh-devel libgcrypt-devel}

%description
Exiv2 comprises of a C++ library and a command line utility to access
image metadata. Exiv2 supports full read and write access to the EXIF and
IPTC metadata, EXIF MakerNote support, extract and delete methods for
EXIF thumbnails, classes to access IFD and so on.

%package -n libexiv2
Summary: EXIF and IPTC metadata manipulation library
Group: Graphics

%description -n libexiv2
libexiv2 is a C++ library to access image metadata.

%package -n libexiv2-devel
Summary: Headers and links to compile against the exiv2 library
Group: Development/C
Requires: libexiv2 = %version-%release

%description -n libexiv2-devel
This package contains all files which one needs to compile programs using the
exiv2 library.

%prep
%setup
%patch -b .lfs

%build
%make -C config -f config.make
%configure \
	--disable-static \
	--disable-rpath \
	%{subst_enable video} \
	%{subst_enable webready}
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall_std
%find_lang exiv2

%files
%_bindir/exiv2
%_man1dir/*
%doc README doc/ChangeLog

%files -n libexiv2 -f exiv2.lang
%_libdir/libexiv2.so.*

%files -n libexiv2-devel
%_libdir/libexiv2.so
%_includedir/*
%_pkgconfigdir/*

%changelog
