%define soversion 2

Name: faad
Version: 2.7
Release: alt4

Packager: Pavlov Konstantin <thresh@altlinux.ru>
Summary: FAAD is a Freeware Advanced Audio Decoder
License: GPL
Group: Sound
Url: http://www.audiocoding.com

Patch1: faad2-alt-fix-no-ext-segfault.patch
Patch2: faad2-alt-make-mp4ff-shared.patch

Source: http://prdownloads.sourceforge.net/faac/%{name}2-%version.tar.bz2

%define libsndfile_ver 1.0.5

Requires: lib%name%soversion = %version-%release

BuildPreReq: libsndfile >= %libsndfile_ver

BuildRequires: gcc-c++ glib-devel gtk+-devel id3lib-devel
BuildRequires: libstdc++-devel libxmms-devel zlib-devel

%description
FAAD is a LC, MAIN and LTP profile MPEG2 and MPEG-4 AAC decoder.

%package -n lib%name%soversion
Summary: Freeware Advanced Audio Decoder (FAAD) libraries
Group: System/Libraries
Provides: lib%name = %version-%release

%description -n lib%name%soversion
This package contains Freeware Advanced Audio Decoder (FAAD) shared
libraries.

%package -n lib%name-devel
Summary: Development files for the FAAD AAC decoder libraries
Group: Development/C++
Requires: lib%name%soversion = %version-%release
Requires: libsndfile-devel >= %libsndfile_ver

%description -n lib%name-devel
This package provides header files development libraries and
documentation for lib%name.

%package -n xmms-in-faad
Summary: FAAD input plugin for XMMS
Group: Sound
Requires: lib%name%soversion = %version-%release
Requires: xmms
Provides: xmms-input-faad = %version-%release
Obsoletes: xmms-input-faad <= %version-%release

%description -n xmms-in-faad
This package provides input plugin allowing XMMS to read .aac and .mp4
files.

%prep
%setup -q -n %{name}2-%version

%patch1 -p2
%patch2 -p2

find ./ -type f -name "Makefile*" -print0 | \
xargs -r0 %__subst 's,^\(CFLAGS\),AM_\1,g
		    s,^\(LDFLAGS\),AM_\1,g
		    s,^[[:blank:]*],\t,' --

%define _xmms_input_plugin_dir %(xmms-config --input-plugin-dir)

%build
%add_optflags %optflags_shared
#%_buildshell ./bootstrap
autoreconf -isfv
%configure --disable-static \
	    --without-drm \
	    --with-xmms

%make_build

%install
%make_install DESTDIR=%buildroot install

# remove non-packaged files
rm -f %buildroot%_libdir/*.la

%files
%_bindir/*
#%_man1dir/*

%files -n lib%name%soversion
%_libdir/*.so.*
%doc AUTHORS ChangeLog NEWS README TODO

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so

%files -n xmms-in-faad
%_xmms_input_plugin_dir/*
%doc plugins/xmms/{AUTHORS,ChangeLog,NEWS,README,TODO}

%changelog
