# Upstream joined two projects, fbi and ida (framebuffer and Motif-based image
# viewers) into united project named "fbida". But we really not interested in
# packaging ugly motif apps, so we will name our main package just "fbi".
Name: fbi
Version: 2.12
Release: alt1

Summary: Image viewer for Linux framebuffer console
License: GPLv2+
Group: Graphics

Url: http://www.kraxel.org/cgit/fbida/
Source: http://www.kraxel.org/releases/fbida/fbida-%version.tar.gz

# Automatically added by buildreq on Mon Jun 06 2016
BuildRequires: libdrm-devel libepoxy-devel libexif-devel libgbm-devel libgif-devel libjpeg-devel liblirc-devel libpoppler-glib-devel libsane-devel libtiff-devel libwebp-devel

%description
Image viewer for Linux framebuffer console.

%package -n exiftran
Summary: Command line tool to do lossless transformations of JPEG images
Group: Graphics

%description -n exiftran
Command line tool to do lossless transformations of JPEG images, similar to
jpegtran but includes EXIF data.

%prep
%setup -n fbida-%version
echo %version > VERSION
# Get rid of build time checks that will bloat buildreq-generated deps.
subst 's/^HAVE_MOTIF.*$//' GNUmakefile

%build
# Must use CFLAGS as env variable, because makefile _adds_ flags to it.
export CFLAGS="%optflags"
%make_build HAVE_MOTIF=no verbose=yes exiftran fbi

%install
%makeinstall_std STRIP="" prefix=%_prefix

%files
%_bindir/fb*
%_man1dir/fb*

%files -n exiftran
%_bindir/exiftran
%_man1dir/exiftran*

%changelog
