Name:           ffc
Version:        1.6.0
Release:        alt1.dev.git20150430
Epoch: 1
Summary:        Compiler for finite element variational forms
Group:          Development/Tools
License:        LGPL v3
URL:            http://fenicsproject.org/
# https://bitbucket.org/fenics-project/ffc.git
Source: %name-%version.tar.gz
Source1: http://www.fenics.org/pub/documents/ffc/ffc-user-manual/ffc-user-manual.pdf
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Requires: python-module-%name = %epoch:%version-%release

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel swig
BuildPreReq: libnumpy-devel python-module-fiat
BuildPreReq: python-module-ferari gcc-c++

Obsoletes: python-module-ufc

%description
FFC is a compiler for finite element variational forms. From a high-level
description of the form, it generates efficient low-level C++ code that
can be used to assemble the corresponding discrete operator (tensor). In
particular, a bilinear form may be assembled into a matrix and a linear
form may be assembled into a vector.

FFC may be used either from the command line (by invoking the 'ffc' command)
or as a Python module ('import ffc').

FFC is part of the FEniCS project (www.fenics.org) and functions as a
just-in-time (JIT) compiler for DOLFIN.

%package doc
Summary: User manual for FFC
Group: Development/Documentation
BuildArch: noarch

%description doc
FFC is a compiler for finite element variational forms. From a high-level
description of the form, it generates efficient low-level C++ code that
can be used to assemble the corresponding discrete operator (tensor). In
particular, a bilinear form may be assembled into a matrix and a linear
form may be assembled into a vector.

This package contains user manual for UFL (Unified Form Language).

%package -n python-module-%name
Summary: Python module of FFC
Group: Development/Python
Requires: python-module-fiat python-module-ferari
%setup_python_module ffc
%py_provides ffc
%py_requires FIAT ferari
Obsoletes: python-module-ufc
#add_python_req_skip reassign

%description -n python-module-%name
FFC is a compiler for finite element variational forms. From a high-level
description of the form, it generates efficient low-level C++ code that
can be used to assemble the corresponding discrete operator (tensor). In
particular, a bilinear form may be assembled into a matrix and a linear
form may be assembled into a vector.

This package contains python module of FFC.

%package -n ufc-devel
Summary: Development files for UFC
Group: Development/Other
Requires: %name = %EVR

%description -n ufc-devel
UFC (Unified Form-assembly Code) is a unified framework for finite
element assembly. More precisely, it defines a fixed interface for
communicating low level routines (functions) for evaluating and
assembling finite element variational forms. The UFC interface
consists of a single header file ufc.h that specifies a C++ interface
that must be implemented by code that complies with the UFC
specification. Examples of form compilers that support the UFC
interface are FFC and SyFi.

This package contains development files for UFC.

%prep
%setup

%build
%python_build

%install
%python_build_install --optimize=2

install -d %buildroot%_docdir/%name
install -p -m644 %SOURCE1 %buildroot%_docdir/%name

%ifarch x86_64
install -d %buildroot%_pkgconfigdir
mv %buildroot%_libexecdir/pkgconfig/* %buildroot%_pkgconfigdir/
%endif

touch %buildroot%python_sitelibdir/ffc_time_ext/__init__.py

%files
%doc README* AUTHORS ChangeLog COPYING
%_bindir/*
%_man1dir/*

%files doc
%_docdir/%name
%doc demo

%files -n python-module-%name
%python_sitelibdir/*

%files -n ufc-devel
%_includedir/*
%_pkgconfigdir/*
%_datadir/ufc

%changelog
