%define _name org.gnome.FileRoller
%define ver_major 3.24
%def_disable packagekit
%def_disable magic
%def_enable libarchive
%def_enable nautilus_actions
%define nau_api_ver 3.0

Name: file-roller
Version: %ver_major.1
Release: alt0.M80P.1

Summary: An archive manager for GNOME
Summary (ru_RU.UTF-8): Архиватор для GNOME
Group: File tools
License: %gpl2plus
Url: http://fileroller.sourceforge.net

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Patch: %name-2.28.2-alt-7z.patch
Patch1: %name-3.3.90-alt-zip_command.patch
# find ./ -type f -print0| xargs -r0 subst "s/x-lzop-compressed-tar/x-tzo/" --
Patch2: %name-3.22.1-alt-tar.lzo_mime_type.patch

# From configure.in
%define glib_ver 2.36.0
%define gtk_ver 3.12.0
%define libarchive_ver 3.0.0
%define desktop_file_utils_ver 0.8

Requires: tar gzip bzip2 ncompress lzop binutils arj lha unrar zip unzip p7zip lzma-utils xz
# Requires: cdrecord # for .iso support
Requires: dconf gnome-icon-theme

BuildPreReq: rpm-build-gnome rpm-build-licenses
# From configure.in
BuildPreReq: yelp-tools itstool
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: intltool >= 0.35.0
BuildPreReq: desktop-file-utils >= %desktop_file_utils_ver
BuildRequires: libjson-glib-devel libnotify-devel
%{?_enable_libarchive:BuildRequires: libarchive-devel >= %libarchive_ver}
%{?_enable_magic:BuildRequires: libmagic-devel}
%{?_enable_nautilus_actions:BuildRequires: libnautilus-devel}

%description
File Roller is an archive manager for the GNOME environment.  This means that
you can : create and modify archives; view the content of an archive; view a
file contained in the archive; extract files from the archive.
File Roller is only a front-end (a graphical interface) to archiving programs
like tar and zip. The supported file types are :
    * Tar archives uncompressed (.tar) or compressed with
          * gzip (.tar.gz, .tgz)
          * bzip (.tar.bz, .tbz)
          * bzip2 (.tar.bz2, .tbz2)
          * compress (.tar.Z, .taz)
          * lzop (.tar.lzo, .tzo)
    * Ar archives (.ar)
    * Arj archives (.arj)
    * Jar archives (.jar, .ear, .war)
    * Lha archives (.lzh)
    * Rar archives (.rar)
    * Zip archives (.zip)
    * 7-Zip archives (.7z)
    * Single files compressed with gzip, bzip, bzip2, compress, lzop

%description -l ru_RU.UTF-8
File Roller - архиватор для рабочего стола GNOME. С его помощью можно:
создавать архивы и изменять их содержимое, читать оглавление архивов,
просматривать и распаковывать заключенные в архив файлы.
File Roller является графической оболочкой к различным средствам сжатия
данных. В число поддерживаемых программой типов архивов входят:
    * Архивы Tar как несжатые (.tar), так и сжатые посредством
          * gzip (.tar.gz, .tgz)
          * bzip (.tar.bz, .tbz)
          * bzip2 (.tar.bz2, .tbz2)
          * compress (.tar.Z, .taz)
          * lzop (.tar.lzo, .tzo)
    * Ar архивы (.ar)
    * Arj архивы (.arj)
    * Jar архивы (.jar, .ear, .war)
    * Lha архивы (.lzh)
    * Rar архивы (.rar)
    * Zip архивы (.zip)
    * 7-Zip архивы (.7z)
    * Отдельные файлы сжатые при помощи gzip, bzip, bzip2, compress, lzop.

%prep
%setup
%patch
%patch1
%patch2 -p1 -b .tzo

rm -f data/%name.desktop{,.in}

%build
%configure \
    --disable-schemas-compile \
    --disable-static \
    %{subst_enable magic} \
    %{subst_enable packagekit} \
    %{subst_enable libarchive} \
    %{?_disable_nautilus_actions:--disable-nautilus-actions}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_libexecdir/%name
%_libexecdir/%name/*.sh
%_libexecdir/%name/rpm2cpio
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/dbus-1/services/%_name.service
%_datadir/dbus-1/services/%_name.ArchiveManager1.service
%_desktopdir/%_name.desktop
%_iconsdir/hicolor/*/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name-symbolic.svg
%config %_datadir/glib-2.0/schemas/*
%_datadir/GConf/gsettings/%name.convert
%_datadir/appdata/%_name.appdata.xml

%if_enabled nautilus_actions
%_libdir/nautilus/extensions-%nau_api_ver/*.so
%exclude %_libdir/nautilus/extensions-%nau_api_ver/*.la
%endif

%doc AUTHORS NEWS README


%changelog
