%define rname firefox
%set_verify_elf_method relaxed

%define firefox_cid     \{ec8030f7-c20a-464f-9b0e-13a3a9e97384\}
%define firefox_prefix  %_libdir/firefox
%define firefox_datadir %_datadir/firefox

%define gst_version 1.0
%define nspr_version 4.21
%define nss_version 3.45.0
%define rust_version  1.35.0
%define cargo_version 1.35.0

Summary:              The Mozilla Firefox project is a redesign of Mozilla's browser
Summary(ru_RU.UTF-8): Интернет-браузер Mozilla Firefox

Name:           firefox-esr
Version:        68.4.1
Release:        alt0.M80P.1
License:        MPL/GPL/LGPL
Group:          Networking/WWW
URL:            http://www.mozilla.org/projects/firefox/

Packager:	Andrey Cherepanov <cas@altlinux.ru>

Source0:        firefox-source.tar
Source1:        rpm-build.tar
Source2:        searchplugins.tar
Source3:        cbindgen-vendor.tar
Source4:        firefox-mozconfig
Source5:        distribution.ini
Source6:        firefox.desktop
Source7:        firefox-wayland.desktop
Source8:        firefox.c
Source9:        firefox-prefs.js

### Start Patches
Patch001: 0001-ALT-fix-werror-return-type.patch
Patch002: 0002-SUSE-NonGnome-KDE-integration.patch
Patch003: 0003-ALT-Use-system-nspr-headers.patch
Patch004: 0004-FEDORA-build-arm-libopus.patch
Patch005: 0005-FEDORA-build-arm.patch
Patch006: 0006-MOZILLA-1196777-GTK3-keyboard-input-focus-sticks-on-.patch
Patch007: 0007-ALT-ppc64le-fix-clang-error-invalid-memory-operand.patch
Patch008: 0008-ALT-ppc64le-disable-broken-getProcessorLineSize-code.patch
Patch010: 0010-ALT-Fix-aarch64-build.patch
### End Patches

BuildRequires(pre): mozilla-common-devel
BuildRequires(pre): rpm-build-mozilla.org
BuildRequires(pre): browser-plugins-npapi-devel

BuildRequires: clang6.0
BuildRequires: clang6.0-devel
BuildRequires: llvm6.0-devel
BuildRequires: lld-devel
BuildRequires: libstdc++-devel
BuildRequires: rpm-macros-alternatives
BuildRequires: rust >= %rust_version
BuildRequires: rustfmt
BuildRequires: rust-cargo >= %cargo_version
BuildRequires: libXt-devel libX11-devel libXext-devel libXft-devel libXScrnSaver-devel
BuildRequires: libXcursor-devel
BuildRequires: libXi-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXdamage-devel
BuildRequires: libcurl-devel libgtk+2-devel libgtk+3-devel libhunspell-devel libjpeg-devel
BuildRequires: xorg-cf-files chrpath alternatives yasm
BuildRequires: zip unzip
BuildRequires: bzlib-devel zlib-devel
BuildRequires: libcairo-devel libpixman-devel
BuildRequires: libGL-devel
BuildRequires: libwireless-devel
BuildRequires: libalsa-devel
BuildRequires: libnotify-devel
BuildRequires: libevent-devel
BuildRequires: libproxy-devel
BuildRequires: libshell
BuildRequires: libvpx5-devel
BuildRequires: libgio-devel
BuildRequires: libfreetype-devel fontconfig-devel
BuildRequires: libstartup-notification-devel
BuildRequires: libffi-devel
BuildRequires: gstreamer%gst_version-devel gst-plugins%gst_version-devel
BuildRequires: libopus-devel
BuildRequires: libpulseaudio-devel
#BuildRequires: libicu-devel
BuildRequires: libdbus-devel libdbus-glib-devel
BuildRequires: node
BuildRequires: nasm
BuildRequires: libxkbcommon-devel

# Python requires
#BuildRequires: /dev/shm
BuildRequires: python3-base
BuildRequires: python-module-distribute
BuildRequires: python-module-pip
BuildRequires: python-modules-compiler
BuildRequires: python-modules-logging
BuildRequires: python-modules-sqlite3
BuildRequires: python-modules-json


# Rust requires
BuildRequires: /proc

# Mozilla requires
BuildRequires: pkgconfig(nspr) >= %nspr_version
BuildRequires: pkgconfig(nss) >= %nss_version
BuildRequires: libnss-devel-static

BuildRequires: autoconf_2.13
%set_autoconf_version 2.13

Obsoletes:	firefox-3.6 firefox-4.0 firefox-5.0
Conflicts:	firefox-settings-desktop

Provides:	webclient
Provides:	firefox = %EVR
Conflicts:	firefox
Requires:	mozilla-common

# ALT#30732
Requires:	gst-plugins-ugly%gst_version

Requires: libnspr >= %nspr_version
Requires: libnss >= %nss_version

%description
The Mozilla Firefox project is a redesign of Mozilla's browser component,
written using the XUL user interface language and designed to be
cross-platform.

%description -l ru_RU.UTF-8
Интернет-браузер Mozilla Firefox - кроссплатформенная модификация браузера Mozilla,
созданная с использованием языка XUL для описания интерфейса пользователя.

%package wayland
Summary:    Firefox Wayland launcher.
Group:      Networking/WWW
BuildArch:  noarch
Requires:   %name

%description wayland
The firefox-wayland package contains launcher and desktop file
to run Firefox natively on Wayland.

%prep
%setup -q -n firefox-%version -c

### Begin to apply patches
%patch001 -p1
%patch002 -p1
%patch003 -p1
%patch004 -p1
%patch005 -p1
%patch006 -p1
%patch007 -p1
%patch008 -p1
%patch010 -p1
### Finish apply patches

cd mozilla

tar -xf %SOURCE1
tar -xf %SOURCE2

cp -f %SOURCE4 .mozconfig

cat >> .mozconfig <<'EOF'
ac_add_options --prefix="%_prefix"
ac_add_options --libdir="%_libdir"
%ifnarch %{ix86} ppc64le
ac_add_options --enable-linker=lld
%ifnarch x86_64
ac_add_options --disable-webrtc
%endif
%endif
%ifarch %{ix86} x86_64
ac_add_options --disable-elf-hack
%endif
EOF

mkdir -p -- my_rust_vendor
tar --strip-components=1 -C my_rust_vendor --overwrite -xf %SOURCE3

mkdir -p -- .cargo
cat > .cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "$PWD/my_rust_vendor"
EOF

%build
cd mozilla

%add_optflags %optflags_shared
%add_findprov_lib_path %firefox_prefix

env CARGO_HOME="$PWD/.cargo" \
	cargo install cbindgen

export MOZ_BUILD_APP=browser

MOZ_OPT_FLAGS="-pipe -O2 -g0"

# PIE, full relro
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -DPIC -fPIC -Wl,-z,relro -Wl,-z,now"

# Add fake RPATH
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -Wl,-rpath,/$(printf %%s '%firefox_prefix' |tr '[:print:]' '_')"

# If MOZ_DEBUG_FLAGS is empty, firefox's build will default it to "-g" which
# overrides the -g0 from line above and breaks building on s390
# (OOM when linking, rhbz#1238225)
export MOZ_DEBUG_FLAGS=" "

export CFLAGS="$MOZ_OPT_FLAGS"
export CXXFLAGS="$MOZ_OPT_FLAGS"
# Add fake RPATH
rpath="/$(printf %%s '%firefox_prefix' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"
%if_without system_nss
# see mozilla/security/nss/coreconf/Linux.mk:203
export RPATH="-Wl,-rpath,$rpath"
%endif

#ifnarch %{ix86}
export CC="clang"
export CXX="clang++"
#else
#export CC="gcc"
#export CXX="g++"
#endif

export LIBIDL_CONFIG=/usr/bin/libIDL-config-2
export srcdir="$PWD"
export SHELL=/bin/sh
export RUST_BACKTRACE=1
export RUSTFLAGS="-Cdebuginfo=0"
export BUILD_VERBOSE_LOG=1
export MOZ_MAKE_FLAGS="-j8"
export PATH="$PWD/.cargo/bin:$PATH"
# Do not require notify-send for building
export MOZ_NOSPAM=1

autoconf old-configure.in > old-configure
pushd js/src
autoconf old-configure.in > old-configure
popd

./mach build || ./mach build

$CC $CFLAGS \
	-Wall -Wextra \
	-DMOZ_PLUGIN_PATH=\"%browser_plugins_path\" \
	-DMOZ_PROGRAM=\"%firefox_prefix/firefox\" \
	-DMOZ_DIST_BIN=\"%firefox_prefix\"\
	%SOURCE8 -o firefox


%install
cd mozilla

export SHELL=/bin/sh

mkdir -p \
	%buildroot/%mozilla_arch_extdir/%firefox_cid \
	%buildroot/%mozilla_noarch_extdir/%firefox_cid \
	#

make -C objdir \
	DESTDIR=%buildroot \
	INSTALL="/bin/install -p" \
	mozappdir=%firefox_prefix \
	libdir=%_libdir \
	install

# install altlinux-specific configuration
install -D -m 644 %SOURCE9 %buildroot/%firefox_prefix/browser/defaults/preferences/all-altlinux.js

cat > %buildroot/%firefox_prefix/browser/defaults/preferences/firefox-l10n.js <<EOF
pref("intl.locale.matchOS", true);
pref("intl.locale.requested", "");
pref("general.useragent.locale", "chrome://global/locale/intl.properties");
EOF

# icons
for s in 16 22 24 32 48 256; do
	install -D -m 644 \
		browser/branding/official/default$s.png \
		%buildroot/%_iconsdir/hicolor/${s}x${s}/apps/firefox.png
done

# ALT#30572
if [ ! -e "%buildroot/%firefox_prefix/plugins" ]; then
	what="$(relative %browser_plugins_path %firefox_prefix/plugins)"
	ln -s -- "$what" %buildroot/%firefox_prefix/plugins
fi

# install rpm-build-firefox
mkdir -p -- \
	%buildroot/%_rpmmacrosdir
sed \
	-e 's,@firefox_version@,%version,' \
	-e 's,@firefox_release@,%release,' \
	rpm-build/rpm.macros.firefox.standalone > %buildroot/%_rpmmacrosdir/firefox

install -m755 firefox %buildroot/%_bindir/firefox

cd %buildroot

# Wrapper for wayland
cat > ./%_bindir/firefox-wayland <<'EOF'
#!/bin/sh
export GDK_BACKEND=wayland
export MOZ_ENABLE_WAYLAND=1
export MOZ_GTK_TITLEBAR_DECORATION=client
export XDG_SESSION_TYPE=wayland

unset DISPLAY

exec %_bindir/firefox "$@"
EOF

chmod +x ./%_bindir/firefox-wayland

# Add distribution.ini
mkdir -p -- ./%firefox_prefix/distribution
cp -- %SOURCE5 ./%firefox_prefix/distribution/distribution.ini

# install menu file
install -D -m 644 %SOURCE6 ./%_datadir/applications/firefox.desktop
install -D -m 644 %SOURCE7 ./%_datadir/applications/firefox-wayland.desktop

# Add alternatives
mkdir -p ./%_altdir
printf '%_bindir/xbrowser\t%_bindir/firefox\t100\n' >./%_altdir/firefox

rm -f -- \
	./%firefox_prefix/removed-files

# Remove devel files
rm -rf -- \
	./%_includedir/%rname \
	./%_datadir/idl/%rname \
	./%_libdir/%rname-devel \
#

# Add real RPATH
(set +x
	rpath="/$(printf %%s '%firefox_prefix' |tr '[:print:]' '_')"
	find %buildroot/%firefox_prefix -type f |
	while read f; do
		t="$(readlink -ev "$f")"
		file "$t" | fgrep -qs ELF || continue
		if chrpath -l "$t" | fgrep -qs "RPATH=$rpath"; then
			chrpath -r "%firefox_prefix" "$t"
		fi
	done
)

%pre
for n in defaults browserconfig.properties; do
	[ ! -L "%firefox_prefix/$n" ] || rm -f "%firefox_prefix/$n"
done

%files
%_altdir/firefox
%_bindir/firefox
%firefox_prefix
%mozilla_arch_extdir/%firefox_cid
%mozilla_noarch_extdir/%firefox_cid
%_datadir/applications/firefox.desktop
%_iconsdir/hicolor/16x16/apps/firefox.png
%_iconsdir/hicolor/22x22/apps/firefox.png
%_iconsdir/hicolor/24x24/apps/firefox.png
%_iconsdir/hicolor/32x32/apps/firefox.png
%_iconsdir/hicolor/48x48/apps/firefox.png
%_iconsdir/hicolor/256x256/apps/firefox.png

%files wayland
%_bindir/firefox-wayland
%_datadir/applications/firefox-wayland.desktop

%changelog
