%def_disable palemoon   # Only compatible versions

%define cid     \{73a6fe31-595d-460b-a920-fcc0f8843232\}

%if_enabled palemoon
%define cid_dir        %palemoon_noarch_extensionsdir/%cid
%endif

%define cidf_dir       %firefox_noarch_extensionsdir/%cid

Summary: NoScript extension for Firefox and Pale Moon (for firefox-esr)
Summary (ru_RU.utf8): Дополнение NoScript для  Firefox и Pale Moon
Name: firefox-esr-noscript
Version: 5.1.8.4
Release: alt1
Source: noscript-%version.xpi
License: GPL
Group: Networking/WWW
Url: http://noscript.net
Packager: Alexey Gladkov <legion@altlinux.ru>
BuildArch: noarch
Conflicts: firefox-noscript

BuildRequires(pre): rpm-build-firefox rpm-build-palemoon
BuildRequires: unzip

%if_enabled palemoon
%package -n palemoon-noscript
Group: System/Libraries
Summary: Plugin NoScript for Pale Moon
Requires: palemoon
%endif

%description
Extra protection for your Firefox: NoScript allows JavaScript,
Java (and other plugins) only for trusted domains of your
choice (e.g. your home-banking web site). This whitelist
based pre-emptive blocking approach  prevents exploitation
of security vulnerabilities (known and even unknown!) with
no loss of functionality.

%description -l ru_RU.utf8
Расширение для вашего браузер:  NoScript позволяет выполнять
скрипты JavaScript, Java (и другие расширения ) только с доверенных
доменов выбранных вами (например: с сайта банковского обслуживания).
Список доверенных сайтов основанн на принципе упреждающей блокировки
угроз, и позволяет предотвращать использование уязвимостей
(как известных, так и ещё неизвестных) без потери функциональности.

%if_enabled palemoon
%description -n palemoon-noscript
Extra protection for your Pale Moon: NoScript allows JavaScript,
Java (and other plugins) only for trusted domains of your
choice (e.g. your home-banking web site). This whitelist
based pre-emptive blocking approach  prevents exploitation
of security vulnerabilities (known and even unknown!) with
no loss of functionality.

%description -l ru_RU.utf8 -n palemoon-noscript
Расширение для вашего браузер:  NoScript позволяет выполнять
скрипты JavaScript, Java (и другие расширения ) только с доверенных
доменов выбранных вами (например: с сайта банковского обслуживания).
Список доверенных сайтов основанн на принципе упреждающей блокировки
угроз, и позволяет предотвращать использование уязвимостей 
(как известных, так и ещё неизвестных) без потери функциональности.
%endif

%prep
%setup -n noscript

%install
%if_enabled palemoon
mkdir -p %buildroot/%cid_dir
cp -r * %buildroot/%cid_dir
%endif

mkdir -p %buildroot/%cidf_dir
cp -r * %buildroot/%cidf_dir

%if_enabled palemoon
%files -n palemoon-noscript
%cid_dir
%endif

%files
%cidf_dir

%postun
if [ "$1" = 0 ]; then
%if_enabled palemoon
	[ ! -d "%cid_dir" ] || rm -rf "%cid_dir"
%endif
	[ ! -d "%cidf_dir" ] || rm -rf "%cidf_dir"
fi

%changelog
