%define flacdocs %_docdir/%name-%version
%define soversion 8
%define cppsoversion 6

%set_verify_elf_method textrel=relaxed

Name: flac
Version: 1.2.1
Release: alt11.1

Summary: Free Lossless Audio Codec
License: GPLv2+
Group: Sound
Url: http://flac.sourceforge.net/
# http://download.sourceforge.net/%name/%name-%version.tar.gz
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: lib%name%soversion = %version-%release

%def_disable static
%{?_enable_static:BuildRequires: glibc-devel-static}

%ifarch %ix86 x86_64
BuildRequires: nasm
%endif

# Automatically added by buildreq on Fri Mar 25 2011
BuildRequires: docbook-utils doxygen gcc-c++ libogg-devel libxmms-devel

%description
FLAC (%url) is an Open Source lossless audio codec.

%package -n lib%name%soversion
Summary: FLAC shared library
Group: System/Libraries
License: BSD-like
Provides: lib%name = %version

%description -n lib%name%soversion
The lib%name package contains a shared library of
functions for manipulating FLAC format audio files.

%package -n lib%name-devel
Summary: Development files for FLAC
Group: Development/C
License: BSD-like
Requires: lib%name%soversion = %version-%release
Provides: liboggflac-devel = %version
Obsoletes: liboggflac-devel < %version

%description -n lib%name-devel
This package contains development files required for packaging
FLAC-based software.

%package -n lib%name-devel-static
Summary: Static libraries for FLAC
Group: Development/C
License: BSD-like
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains development libraries required for packaging
statically linked FLAC-based software.

%package -n lib%name++%cppsoversion
Summary: Object shared library FLAC++
Group: System/Libraries
License: BSD-like
Requires: lib%name%soversion = %version-%release
Provides: lib%name++ = %version

%description -n lib%name++%cppsoversion
The lib%name++%cppsoversion package contains a object wrapper library
of functions for manipulating FLAC format audio files.

%package -n lib%name++-devel
Summary: Development files for FLAC++ library
Group: Development/C
License: BSD-like
Requires: lib%name++%cppsoversion = %version-%release
Provides: liboggflac++-devel = %version
Obsoletes: liboggflac++-devel < %version

%description -n lib%name++-devel
This package contains development files required for packaging
FLAC++-based software.

%package -n lib%name++-devel-static
Summary: Static libraries for FLAC++ library
Group: Development/C
License: BSD-like
Requires: lib%name++-devel = %version-%release

%description -n lib%name++-devel-static
This package contains development libraries required for packaging
statically linked FLAC++-based software.

%package -n xmms-in-%name
Summary: Plugin for XMMS
Group: Sound
License: GPLv2+
Provides: xmms-%name
Obsoletes: xmms-%name
Requires: lib%name%soversion = %version-%release

%description -n xmms-in-%name
Xmms plugin for playing FLAC files.

%prep
%setup
%patch -p1

%build
# due to libtool mess
%autoreconf
%configure --enable-exhaustive-tests %{subst_enable static}
%make_build

%install
%makeinstall xmmsinputplugindir=%buildroot%xmms_inputdir
install -pm644 COPYING.Xiph AUTHORS README %buildroot%flacdocs/

%check
%make_build -k check

%files
%_bindir/*
%_mandir/man?/*
%dir %flacdocs/
%dir %flacdocs/html/
%flacdocs/html/*.html
%flacdocs/html/*.ico
%flacdocs/html/*.css
%flacdocs/html/ru
%flacdocs/html/images

%files -n lib%name%soversion
%_libdir/libFLAC.so.*
%dir %flacdocs/
%flacdocs/AUTHORS
%flacdocs/README
%flacdocs/COPYING.Xiph

%files -n lib%name-devel
%_datadir/aclocal/libFLAC.m4
%_libdir/libFLAC.so
%_includedir/FLAC
%_pkgconfigdir/flac.pc
%dir %flacdocs/
%dir %flacdocs/html
%flacdocs/html/api
%flacdocs/FLAC.tag

%if_enabled static
%files -n lib%name-devel-static
%_libdir/libFLAC.a
%endif

%files -n lib%name++%cppsoversion
%_libdir/libFLAC++.so.*

%files -n lib%name++-devel
%_datadir/aclocal/libFLAC++.m4
%_libdir/libFLAC++.so
%_includedir/FLAC++
%_pkgconfigdir/flac++.pc

%if_enabled static
%files -n lib%name++-devel-static
%_libdir/libFLAC++.a
%endif

%files -n xmms-in-%name
%_libdir/xmms/Input/*

%changelog
