%define _name org.gnome.FontManager
Name: font-manager
Version: 0.7.2
Release: alt1

Summary: A font management application for the GNOME desktop
License: GPLv3
Group: Graphical desktop/GNOME
Url: http://code.google.com/p/%name

#Source: http://%name.googlecode.com/files/%name-%version.tar.bz2
Source: %name-%version.tar

BuildRequires: libgtk+3-devel libjson-glib-devel libgee0.8-devel
BuildRequires: libgucharmap-devel libsqlite3-devel libxml2-devel
BuildRequires: intltool yelp-tools
BuildRequires: vala-tools
BuildRequires: gobject-introspection-devel libgucharmap-gir-devel

%description
Font Manager is an application that allows users to easily manage fonts
on their system.

Font Manager is not intended to be a professional-grade font management
solution, but rather a simple application suitable for the needs of most
desktop users, and even graphics designers who may need to manage just a
few thousand font files.

Although designed with the GNOME desktop environment in mind, it should
work well with most major desktop environments such as XFCE,
Enlightenment, and even KDE.


%prep
%setup

%build
%autoreconf
export ac_cv_prog_HAVE_FILE_ROLLER="yes"
%configure
# SMP-incompatible build
%make

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%_name.desktop
%_datadir/dbus-1/services/%_name.service
%_datadir/glib-2.0/schemas/%_name.gschema.xml
%_datadir/appdata/%name.appdata.xml
%doc README


%changelog
