Name: fontconfig
Version: 2.12.6
Release: alt1%ubt

Summary: Font configuration and customization library and utilities
Group: System/Configuration/Other
License: MIT
Url: http://fontconfig.org/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Source1: fontconfig-firsttime
Source2: fontconfig.filetrigger
# FC
Patch1: fontconfig-sleep-less.patch
# ALT
Patch11: alt-symbols-map.patch
Patch12: alt-config.patch
Patch13: alt-fc-conf.patch
Patch14: alt-disable-postscript-aliases.patch

Provides: lib%name = %version
Obsoletes: lib%name < %version
BuildRequires(pre): rpm-build-ubt
BuildRequires: docbook-utils elinks gperf libexpat-devel libfreetype-devel
BuildRequires: python2.7(urllib2) python2.7(lxml) python2.7(six) python2.7(distutils)

%description
Fontconfig is designed to locate fonts within the system and
select them according to requirements specified by applications.

%package devel
Summary: Development files for font configuration and customization library
Group: Development/C
Requires: %name = %version-%release

%description devel
This package includes the fontconfig header files and developer
documentation required for development of fontconfig-based software.

%define docdir %_docdir/%name

%prep
%setup -q
%patch1 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%autoreconf

%build
%configure \
	--disable-static \
	--with-baseconfigdir=%_sysconfdir/fonts \
	--with-default-fonts=%_datadir/fonts \
	--with-cache-dir=%_var/cache/%name \
	--docdir=%docdir \
	--with-default-hinting=full \
	#

%make PDF_FILES=

%install
%make DESTDIR=%buildroot PDF_FILES= install
install -pm644 AUTHORS README %buildroot%docdir/

> %buildroot%_sysconfdir/fonts/local.conf
install -Dp -m755 %SOURCE1 %buildroot%_sysconfdir/firsttime.d/%name
install -Dp -m755 %SOURCE2 %buildroot%_rpmlibdir/%name.filetrigger

for f in $(ls %buildroot%_datadir/%name/conf.avail/1*.conf | sed -ne 's|\(.*/\)\(.*conf\)|\2|p'); do
	ln -sf ../../../%_datadir/%name/conf.avail/$f %buildroot%_sysconfdir/fonts/conf.d/$f
done

# add compatibility symlinks
find %buildroot/%_datadir/%name/conf.avail/ -type f -name \*.conf | sed -e 's|^.*/||' | \
while read CONF ; do
    ln -s `relative %_datadir/%name/conf.avail/$CONF %_sysconfdir/fonts/conf.avail/$CONF` %buildroot/%_sysconfdir/fonts/conf.avail/$CONF
done
find %buildroot/%_sysconfdir/fonts/conf.avail/ -type f -name \*.conf | sed -e 's|^.*/||' | \
while read CONF ; do
    ln -s `relative %_sysconfdir/fonts/conf.avail/$CONF %_datadir/%name/conf.avail/$CONF` %buildroot/%_datadir/%name/conf.avail/$CONF
done

%post
[ -n "$DURING_INSTALL" ] || %_sysconfdir/firsttime.d/%name ||:

%triggerin -- %name < 2.10.91-alt2
find %_datadir/fonts -depth -type f -name fonts.cache-1 -delete
find %_var/cache/%name -depth -type f -name \*.cache-\[123\] -delete

%triggerpostun -- %name < 2.10.0-alt1
find -L %_sysconfdir/fonts/conf.d -type l -delete

%files
%_sysconfdir/firsttime.d/%name
%dir %_sysconfdir/fonts
%dir %_sysconfdir/fonts/conf.d
%dir %_sysconfdir/fonts/conf.avail
%config %_sysconfdir/fonts/fonts.conf
%config(noreplace) %_sysconfdir/fonts/conf.avail/*.conf
%_sysconfdir/fonts/conf.d/README
%_sysconfdir/fonts/conf.d/[2-9]*.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/10-antialias.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/10-hinting.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/10-hinting-full.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/10-sub-pixel-rgb.conf
%config(noreplace) %_sysconfdir/fonts/conf.d/11-lcdfilter-default.conf
%ghost %_sysconfdir/fonts/conf.d/10-autohint.conf
%ghost %_sysconfdir/fonts/conf.d/10-no-antialias.conf
%ghost %_sysconfdir/fonts/conf.d/10-no-sub-pixel.conf
%ghost %_sysconfdir/fonts/conf.d/10-scale-bitmap-fonts.conf
%ghost %_sysconfdir/fonts/conf.d/10-hinting-slight.conf
%ghost %_sysconfdir/fonts/conf.d/10-hinting-medium.conf
%ghost %_sysconfdir/fonts/conf.d/10-hinting-none.conf
%ghost %_sysconfdir/fonts/conf.d/10-sub-pixel-bgr.conf
%ghost %_sysconfdir/fonts/conf.d/10-sub-pixel-vbgr.conf
%ghost %_sysconfdir/fonts/conf.d/10-sub-pixel-vrgb.conf
%ghost %_sysconfdir/fonts/conf.d/10-unhinted.conf
%ghost %_sysconfdir/fonts/conf.d/11-lcdfilter-legacy.conf
%ghost %_sysconfdir/fonts/conf.d/11-lcdfilter-light.conf
%ghost %_sysconfdir/fonts/conf.d/11-lcdfilter-none.conf
%ghost %config(missingok,noreplace) %_sysconfdir/fonts/local.conf
%_bindir/fc-*
%_libdir/*.so.*
%_rpmlibdir/%name.filetrigger
%_datadir/%name
%_datadir/xml/%name
%_man1dir/*
%_man5dir/*
%dir %_var/cache/%name
%docdir
%exclude %docdir/%name-devel*

%files devel
%_libdir/*.so
%_pkgconfigdir/*.pc
%_includedir/*
%_man3dir/*
%dir %docdir
%docdir/%name-devel*

%changelog
