# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%def_enable docs
%def_enable python


Name: fontforge
Version: 20170731
Release: alt0.M80P.1
Summary: FontForge -- font editor

License: BSD
Group: Publishing
Url: http://fontforge.sourceforge.net/

# Source-url: https://github.com/fontforge/fontforge/archive/%version.tar.gz
Source: %name-%version.tar

# manually removed: glibc-devel-static packages-info-i18n-common
# Automatically added by buildreq on Wed Nov 30 2016
# optimized out: ca-certificates fontconfig fontconfig-devel glib2-devel gnu-config ipython libICE-devel libX11-devel libXft-devel libXrender-devel libcairo-devel libfreetype-devel libpng-devel libwayland-client libwayland-server pkg-config python-base python-devel python-module-decorator python-module-future python-module-google python-module-ipython_genutils python-module-path python-module-pexpect python-module-pickleshare python-module-ptyprocess python-module-simplegeneric python-module-traitlets python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-json python-modules-logging python-modules-sqlite3 python3 python3-base shared-mime-info tzdata xorg-inputproto-devel xorg-kbproto-devel xorg-renderproto-devel xorg-xproto-devel zlib-devel
BuildRequires: desktop-file-utils git-core imake indent libSM-devel libXi-devel libgif-devel libgio-devel libjpeg-devel libltdl7-devel libpango-devel libreadline-devel libspiro-devel libtiff-devel libuninameslist-devel libxml2-devel python-module-mwlib python3-dev unzip wget xorg-cf-files

BuildRequires: libuthash-devel gnulib

%if_enabled python
# BuildRequires: python-module-mwlib python3-dev python3-module-yieldfrom python3-module-zope
BuildRequires: python3-dev
%endif

Requires: lib%name = %version-%release

%description
FontForge allows the user to create and modify 
Type 1 (postscript) and true type fonts.
User can save fonts in different postscript 
formats and generate bitmaps.

%description -l ru_RU.UTF-8
FontForge позволяет пользователям создавать и изменять 
шрифты форматов Type1 (postscipt) и True Type. 
Возможно сохранять шрифты в различных
форматах postscript и генерировать 
растровые изображения шрифтов.

%package -n lib%name
Summary: FontForge shared library
Group: System/Libraries

%package -n lib%name-devel
Summary: FontForge development files
Group: Development/C
Requires: lib%name = %version-%release

%if_enabled python
%package -n python-module-%name
Summary: FontForge python module
Group: Development/Python
Requires: python
Requires: lib%name = %version-%release

%description -n python-module-%name
FontForge python module
%endif

%if_enabled docs
%package docs
Summary: FontForge documentations
Group: Publishing

%description docs
FontForge documentations
%endif

%description -n lib%name
FontForge shared library

%description -n lib%name-devel
FontForge development files

%prep
%setup -q -n %{name}-%version
# hack to make an illision about local uthash and prevent download it
mkdir -p uthash/src

%build
./bootstrap --skip-git --skip-po --gnulib-srcdir=/usr/share/gnulib
#autoreconf
%configure --disable-rpath --disable-static
#sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool

# disable rpath
sed -ri 's/^(hardcode_libdir_flag_spec).*$/\1=/' libtool
sed -ri 's/^(runpath_var).*$/\1=/' libtool
%make_build

%install
%makeinstall_std

%find_lang FontForge

%files -f FontForge.lang
%doc LICENSE
%_bindir/*
%_datadir/%name/
%_man1dir/*
%_desktopdir/%name.desktop
%_iconsdir/*/*/*/*.*
%_datadir/mime/packages/*

%files -n lib%name
%_libdir/libgunicode.so.*
%_libdir/libgdraw.so.*
%_libdir/libfontforge.so.*
%_libdir/libgutils.so.*
%_libdir/libgioftp.so.*
%_libdir/libfontforgeexe.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/%name/
%_pkgconfigdir/*.pc

%if_enabled python
%files -n python-module-%name
%python_sitelibdir/*.so
%python_sitelibdir/*.la
%endif

%if_enabled docs
%files docs
%_docdir/%name/*.*
%_docdir/%name/flags/*.*
%_docdir/%name/.htaccess
%_docdir/%name/nonBMP/*
%endif


%changelog
