%define _name dejavu-lgc-fonts-ttf
%define fname dejavu-lgc

Name: fonts-ttf-%fname
Version: 2.35
Release: alt1

Summary: A font family based on the Bitstream Vera Fonts (Latin, Greek, Cyrillic)
License: %gpl2plus
Group: System/Fonts/True type

Url: http://dejavu.sourceforge.net
Source0: http://downloads.sourceforge.net/dejavu/%_name-%version.tar.bz2
Source1: 59-dejavu-lgc-minimal.conf
Source2: 20-unhint-small-dejavu-lgc-minimal.conf
Source3: dejavu-lgc-minimal-README.ALT
Source4: dejavu-lgc-fonts-ttf.watch
Packager: Michael Shigorin <mike@altlinux.org>

BuildArch: noarch
BuildPreReq: rpm-build-licenses
BuildPreReq: rpm-build-fonts >= 0.3
PreReq: fontconfig >= 2.4.2

Summary(ru_RU.UTF-8): Шрифты, основанные на Bitstream Vera (латиница, кириллица и греческий)

%description
The DejaVu fonts are a font family based on the Bitstream Vera Fonts
release 1.10. Its purpose is to provide a wider range of characters
(see Current status page for more information) while maintaining the
original look and feel.

This package contains only Latin, Greek, Cyrillic glyphs subset.
If you need full range of glyphs, install fonts-ttf-dejavu.

%description -l ru_RU.UTF-8
DejaVu - это набор шрифтов, основанных на Bitstream Vera release 1.10.
Цель проекта DejaVu - предоставить более широкий набор символов,
сохраняя при этом первоначальный облик шрифта.

Этот пакет содержит только латинские, греческие и кириллические глифы.
Если требуется полный диапазон, установите fonts-ttf-dejavu.

%package minimal
Summary: Minimal set of Dejavu LGC fonts
Group: System/Fonts/True type
# there's no file conflict but duplication if both are installed
Conflicts: %name

%description minimal
%summary for use in ALT Linux installer

%prep
%setup -n %_name-%version

%install
pushd ttf
%ttf_fonts_install %fname
popd
mkdir -p %buildroot%_sysconfdir/fonts/conf.avail
# wonder if I broke things by using all upstream configs now...
install -pm644 fontconfig/*.conf %buildroot%_sysconfdir/fonts/conf.avail/
# minimal subpackage
mkdir ttf-minimal
cp -al ttf/DejaVuLGCSans{,Mono}{,-Bold,-Oblique,-BoldOblique}.ttf ttf-minimal/
pushd ttf-minimal
%ttf_fonts_install %fname-minimal
popd
install -pm644 %SOURCE1 %SOURCE2 %buildroot%_sysconfdir/fonts/conf.avail/
install -pm644 %SOURCE3 README.ALT

%files -f ttf/%fname.files
%_sysconfdir/fonts/conf.avail/*.conf
%exclude %_sysconfdir/fonts/conf.avail/??-%fname-minimal.conf
%exclude %_sysconfdir/fonts/conf.avail/??-unhint-small-%fname-minimal.conf
%doc AUTHORS BUGS LICENSE NEWS README langcover-lgc.txt unicover-lgc.txt

%files minimal -f ttf-minimal/%fname-minimal.files
%_sysconfdir/fonts/conf.avail/??-%fname-minimal.conf
%_sysconfdir/fonts/conf.avail/??-unhint-small-%fname-minimal.conf
%doc LICENSE README.ALT

%changelog
