%define priority 60
%define fontname liberation
%define fontconf %{priority}-%{fontname}
%define oldname liberation-fonts

Name: fonts-ttf-%fontname
Version: 2.00.3
Release: alt2

Summary: Fonts to replace commonly used Microsoft Windows Fonts

License: SIL Open Font License Version 1.1
Group: System/Fonts/True type
Url: https://github.com/liberationfonts/liberation-fonts

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/liberationfonts/liberation-fonts/archive/%version.tar.gz
Source: %name-%version.tar
Source2:          %{oldname}-mono.conf
Source3:          %{oldname}-sans.conf
Source4:          %{oldname}-serif.conf

BuildArch: noarch

Provides: fonts-ttf-core

# TODO: split into subpackages
Provides: fonts-ttf-liberation-mono = %version
Provides: fonts-ttf-liberation-sans = %version
Provides: fonts-ttf-liberation-serif = %version

# To satisfy requirements of official Google Chrome RPM package
Provides: liberation-fonts

BuildRequires: rpm-build-fonts rpm-macros-fontpackages
BuildRequires: python3-module-fonttools fontforge fontpackages-devel

%description
The Liberation Fonts are intended to be replacements for the three
most commonly used fonts on Microsoft systems: Times New Roman,
Arial, and Courier New.

%prep
%setup

%build

# Fedora fix for https://bugzilla.redhat.com/show_bug.cgi?id=1526510
sed -i 's/OS2_UseTypoMetrics: 1/OS2_UseTypoMetrics: 0/g' src/*.sfd

%make_build
mv liberation-fonts-ttf-%version/*.ttf ./

%install
%ttf_fonts_install %fontname

mkdir -p %{buildroot}%{_fontconfig_templatedir}/ %{buildroot}%{_fontconfig_confdir}/
# Repeat for every font family
install -m 0644 -p %{SOURCE2} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-mono.conf
install -m 0644 -p %{SOURCE3} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-sans.conf
install -m 0644 -p %{SOURCE4} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-serif.conf

for fconf in %{fontconf}-mono.conf \
             %{fontconf}-sans.conf \
             %{fontconf}-serif.conf; do
  ln -s %{_fontconfig_templatedir}/$fconf \
        %{buildroot}%{_fontconfig_confdir}/$fconf
done

%files -f %fontname.files
%doc LICENSE README AUTHORS ChangeLog
%{_fontconfig_templatedir}/*-%{fontname}-*.conf
%config(noreplace) %{_fontconfig_confdir}/*-%{fontname}-*.conf

%changelog
