%define oldname linux-libertine-fonts
%global fontname            linux-libertine
%global prio_libertine      60
%global prio_biolinum       61
%global fontconf_libertine  %{prio_libertine}-%{fontname}-libertine.conf
%global fontconf_biolinum   %{prio_biolinum}-%{fontname}-biolinum.conf
%global fontconf_metrics    29-%{fontname}-metrics-alias.conf
%global archivename         LinLibertine
%define posttag             2012_07_02

%define common_desc                                                     \
The Linux Libertine Open Fonts are a TrueType font family for practical \
use in documents.  They were created to provide a free alternative to   \
proprietary standard fonts.

Name:           fonts-ttf-linuxlibertine
Version:        5.3.0
Release:        alt1_5.%{posttag}
Summary:        Linux Libertine Open Fonts

Group:          System/Fonts/True type
License:        GPLv2+ with exceptions or OFL
URL:            http://linuxlibertine.sf.net
Source0:        http://download.sourceforge.net/sourceforge/linuxlibertine/LinLibertineOTF_%{version}_%{posttag}.tgz
Source1:        %{oldname}-libertine-fontconfig.conf
Source2:        %{oldname}-biolinum-fontconfig.conf
Source3:        %{oldname}-libertine-metrics-alias-fontconfig.conf

BuildArch:      noarch
BuildRequires:  fontpackages-devel
#BuildRequires:  fontforge
Requires:       %{name}-common = %{version}-%{release}
Source44: import.info

%description
%common_desc

This package contains Serif fonts.

%package -n fonts-ttf-linuxlibertine-biolinum
Summary:        Sans-serif fonts from Linux Libertine Open Fonts
Requires:       %{name}-common = %{version}-%{release}
Group:          System/Fonts/True type

%description -n fonts-ttf-linuxlibertine-biolinum
%common_desc

This package contains Sans fonts.

%package common
Summary:        Common files for Linux Libertine Open Fonts
Group:          System/Fonts/True type

%description common
%common_desc

This package consists of files used by other %{oldname} packages.

%prep
%setup -n %{oldname}-%{version} -q -c
sed -i -e 's/\r//' OFL-1.1.txt

%build
#for i in $(find -name '*.sfd'); do
#  (cd scripts;
#   ./bailly-2.sh "../$i" ttf
#  )
#done
#mv scripts/*.ttf .

%install
rm -fr %{buildroot}
install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p *.otf %{buildroot}%{_fontdir}

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

install -m 0644 -p %{SOURCE1} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf_libertine}
install -m 0644 -p %{SOURCE2} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf_biolinum}
install -m 0644 -p %{SOURCE3} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf_metrics}

for fconf in %{fontconf_libertine} %{fontconf_metrics} %{fontconf_biolinum}; do
    ln -s %{_fontconfig_templatedir}/$fconf \
          %{buildroot}%{_fontconfig_confdir}/$fconf
done
# generic fedora font import transformations
# move fonts to corresponding subdirs if any
for fontpatt in OTF TTF TTC otf ttf ttc pcf pcf.gz bdf afm pfa pfb; do
    case "$fontpatt" in 
	pcf*|bdf*) type=bitmap;;
	tt*|TT*) type=ttf;;
	otf|OTF) type=otf;;
	afm*|pf*) type=type1;;
    esac
    find $RPM_BUILD_ROOT/usr/share/fonts -type f -name '*.'$fontpatt | while read i; do
	j=`echo "$i" | sed -e s,/usr/share/fonts/,/usr/share/fonts/$type/,`;
	install -Dm644 "$i" "$j";
	rm -f "$i";
	olddir=`dirname "$i"`;
	mv -f "$olddir"/{encodings.dir,fonts.{dir,scale,alias}} `dirname "$j"`/ 2>/dev/null ||:
	rmdir -p "$olddir" 2>/dev/null ||:
    done
done
# kill invalid catalogue links
if [ -d $RPM_BUILD_ROOT/etc/X11/fontpath.d ]; then
    find -L $RPM_BUILD_ROOT/etc/X11/fontpath.d -type l -print -delete ||:
    # relink catalogue
    find $RPM_BUILD_ROOT/usr/share/fonts -name fonts.dir | while read i; do
	pri=10;
	j=`echo $i | sed -e s,$RPM_BUILD_ROOT/usr/share/fonts/,,`; type=${j%%%%/*}; 
	pre_stem=${j##$type/}; stem=`dirname $pre_stem|sed -e s,/,-,g`;
	case "$type" in 
	    bitmap) pri=10;;
	    ttf|ttf) pri=50;;
	    type1) pri=40;;
	esac
	ln -s /usr/share/fonts/$j $RPM_BUILD_ROOT/etc/X11/fontpath.d/"$stem:pri=$pri"
    done ||:
fi

%files common
%doc Bugs.txt ChangeLog.txt GPL.txt LICENCE.txt OFL-1.1.txt Readme-TEX.txt README

%files
%{_fontconfig_templatedir}/%{fontconf_libertine}
%config(noreplace) %{_fontconfig_confdir}/%{fontconf_libertine}
%{_fontbasedir}/*/%{_fontstem}/LinLibertine*.otf

%{_fontconfig_templatedir}/%{fontconf_metrics}
%{_fontconfig_confdir}/%{fontconf_metrics}

%files -n fonts-ttf-linuxlibertine-biolinum
%{_fontconfig_templatedir}/%{fontconf_biolinum}
%config(noreplace) %{_fontconfig_confdir}/%{fontconf_biolinum}
%{_fontbasedir}/*/%{_fontstem}/LinBiolinum*.otf

%changelog
