%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

%define over 3.30
Name: freefemxx
Version: 3.30
Release: alt1
Summary: Implementation of a language dedicated to the finite element method
License: LGPL v2.1+
Group: Sciences/Mathematics
Url: http://www.freefem.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: %mpiimpl-devel libarpack-devel
BuildPreReq: liblapack-devel libfltk-devel libsuitesparse-devel
BuildPreReq: libX11-devel libGL-devel libGLU-devel libgsl-devel
BuildPreReq: libGLUT-devel flex libICE-devel libXpm-devel
BuildPreReq: libfftw3-mpi-devel libtetgen-devel libmumps-devel
BuildPreReq: libsuperlu-devel libblacs-devel libscalapack-devel
BuildPreReq: libscotch-devel libparmetis-devel chrpath libXext-devel
BuildPreReq: libsuperlu_dist-devel f2c libf2c-ng-devel libhypre-devel
BuildPreReq: libparms-devel libpastix-devel libXxf86vm-devel
BuildPreReq: mmg3d libmmg3d-devel libipopt-devel

Conflicts: bamg

%description
FreeFem++ is an implementation of a language dedicated to the finite
element method. It enables you to solve Partial Differential Equations
(PDE) easily.

Problems involving PDE from several branches of physics such as
fluid-structure interactions require interpolations of data on several
meshes and their manipulation within one program. FreeFem++ includes a
fast quadtree-based interpolation algorithm and a language for the
manipulation of data on multiple meshes (generated with bamg).

%package examples
Summary: Examples for FreeFem++
Group: Documentation
BuildArch: noarch

%description examples
FreeFem++ is an implementation of a language dedicated to the finite
element method. It enables you to solve Partial Differential Equations
(PDE) easily.

Problems involving PDE from several branches of physics such as
fluid-structure interactions require interpolations of data on several
meshes and their manipulation within one program. FreeFem++ includes a
fast quadtree-based interpolation algorithm and a language for the
manipulation of data on multiple meshes (generated with bamg).

This package contains examples for FreeFem++.

%package doc
Summary: Documentation for FreeFem++
Group: Documentation
BuildArch: noarch

%description doc
FreeFem++ is an implementation of a language dedicated to the finite
element method. It enables you to solve Partial Differential Equations
(PDE) easily.

Problems involving PDE from several branches of physics such as
fluid-structure interactions require interpolations of data on several
meshes and their manipulation within one program. FreeFem++ includes a
fast quadtree-based interpolation algorithm and a language for the
manipulation of data on multiple meshes (generated with bamg).

This package contains documentation for FreeFem++.

%prep
%setup

for i in arpack blacs blas f2c fftw fltk hypre metis mumps parmetis \
	parms pastix scalapack scotch superlu superludist tetgen umfpack
do
	rm download/$i -fR
done

%build
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath=%mpidir/lib -L%mpidir/lib"
export MPIDIR=%mpidir

INCS="-I%_includedir/suitesparse -I%mpidir/include"
INCS="$INCS -I%mpidir/include/metis -I%_includedir/fftw3-mpi"
INCS="$INCS -I%_includedir/openblas -I%_includedir/mmg3d"
INCS="$INCS -include stdio.h -include mpi.h"
%add_optflags $INCS -fno-strict-aliasing -fpermissive
%autoreconf
%configure \
%ifarch x86_64
	--enable-m64 \
%else
	--enable-m32 \
%endif
	--enable-optim \
	--with-x \
	--enable-opengl \
	--enable-default-fltk=yes \
	--with-mpipath=%mpidir \
	--with-mpi=openmpi \
	--with-mpilibs="-L%mpidir/lib -lmpi_f90  -lmpi_cxx -lmpi -lopen-rte -lopen-pal -lutil" \
	--with-mpilibsc="-L%mpidir/lib -lmpi -lopen-rte -lopen-pal -lutil" \
	--with-mpiinc="-I%mpidir/include" \
	--with-blas="-lopenblas" \
	--with-lapack="-llapack" \
	--with-arpack="-larpack_LINUX -L%mpidir/lib -lmpi_cxx" \
	--with-amd="-lamd" \
	--with-umfpack="-lumfpack" \
	--without-cadna
%make

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath=%mpidir/lib -L%mpidir/lib"
export MPIDIR=%mpidir

%makeinstall_std

#chrpath -r %mpidir/lib %buildroot%_bindir/FreeFem++-mpi

%files
%doc AUTHORS BUGS ChangeLog COPYING HISTORY* INNOVATION TODO NEWS README
%_bindir/*

%files examples
%dir %_datadir/freefem++
%dir %_datadir/freefem++/%over
%_datadir/freefem++/%over/examples*
%_datadir/freefem++/%over/*.zip

%files doc
%doc DOC/*.pdf

%changelog
