%define plugin_dir %_libdir/dirsrv/plugins
%define POLICYCOREUTILSVER 2.1.12
%define _localstatedir %_var
%define _libexecdir /usr/libexec
%define etc_systemd_dir %_sysconfdir/systemd/system
%define pki_core_version 10.2.6-alt4_19jpp8
%define krb5_version 1.14.4-alt2
%define sssd_version 1.14.2-alt5
%define apache_conf_dir %_sysconfdir/httpd2/conf

%define _unpackaged_files_terminate_build 1

Name: freeipa
Version: 4.3.3
Release: alt20
Summary: The Identity, Policy and Audit system

Group: System/Base
License: GPLv3+
Url: http://www.freeipa.org/
Source: %name-%version.tar
Source1: ipa-nss.conf
Source2: ipa_configured
Source3: ipa-nss.load
Source4: freeipa-server.filetrigger
Patch: %name-%version-alt.patch

BuildRequires: 389-ds-devel >= 1.3.1.3
BuildRequires: libsvrcore-devel
BuildRequires: policycoreutils >= %POLICYCOREUTILSVER
BuildRequires: systemd-devel
BuildRequires: samba-devel >= 4.0.5
BuildRequires: python-module-samba
BuildRequires: libwbclient-devel
BuildRequires: libtalloc-devel
BuildRequires: libtevent-devel
BuildRequires: libnspr-devel
BuildRequires: libnss-devel
BuildRequires: libssl-devel
BuildRequires: libldap-devel
BuildRequires: libkrb5-devel >= %krb5_version
BuildRequires: libuuid-devel
BuildRequires: libcurl-devel >= 7.21.7-2
BuildRequires: libxmlrpc-devel >= 1.27.4
BuildRequires: libpopt-devel
BuildRequires: gettext
BuildRequires: python-devel
BuildRequires: python-module-ldap
BuildRequires: python-module-setuptools
BuildRequires: python-module-krbV
BuildRequires: python-module-nss
BuildRequires: python-module-netaddr
BuildRequires: python-module-kerberos
BuildRequires: python-module-cryptography >= 0.9
BuildRequires: python-module-OpenSSL
BuildRequires: pylint
BuildRequires: python-module-polib
BuildRequires: python-module-ipa_hbac
BuildRequires: python-module-memcached
BuildRequires: sssd >= %sssd_version
BuildRequires: python-module-lxml
BuildRequires: python-module-pyasn1 >= 0.0.9a
BuildRequires: python-module-dns
BuildRequires: python-module-lesscpy
BuildRequires: python-module-cffi
BuildRequires: python-module-six
BuildRequires: python-module-gssapi
BuildRequires: libsss_idmap-devel >= %sssd_version
BuildRequires: libsss_nss_idmap-devel >= %sssd_version
BuildRequires: java-1.8.0-openjdk
BuildRequires: libverto-devel
BuildRequires: systemd
BuildRequires: libunistring-devel
BuildRequires: libsasl2-devel
BuildRequires: rpm-macros-webserver-common
BuildRequires: libini_config-devel

BuildRequires: rhino

# the following packages are required for tests
%{?!_without_check:%{?!_disable_check:BuildRequires: libcmocka-devel krb5-kinit python2.7(yubico) python2.7(usb.core) python2.7(qrcode) nss_wrapper python-modules-json}}


%description
IPA is an integrated solution to provide centrally managed Identity
(machine, user, virtual machines, groups, authentication credentials),
Policy (configuration settings, access control information) and Audit
(events, logs, analysis thereof).

###############################################################################

%package server
Summary: The IPA authentication server
Group: System/Base
Requires: %name-server-common = %version-%release
Requires: python-module-ipaserver = %version-%release
Requires: python-module-%name = %version-%release
Requires: %name-client = %version-%release
Requires: %name-admintools = %version-%release
Requires: krb5-kinit >= %krb5_version
Requires: pki-server >= %pki_core_version
Requires: pki-ca >= %pki_core_version
Requires: pki-kra >= %pki_core_version
Requires: java-1.8.0-openjdk
Requires: apache2-mod_nss
Requires: apache2-mod_auth_gssapi
Requires: apache2-mod_wsgi
Requires: krb5-kdc >= %krb5_version
Requires: 389-ds-base
Requires: memcached
Requires: python-module-kdcproxy
Requires: oddjob
Requires: slapi-nis >= 0.55

%description server
IPA is an integrated solution to provide centrally managed Identity
(machine, user, virtual machines, groups, authentication credentials),
Policy (configuration settings, access control information) and Audit
(events, logs, analysis thereof).
If you are installing an IPA server you need to install this package
(in other words, most people should NOT install this package).

###############################################################################

%package -n python-module-ipaserver
Summary: Python libraries used by IPA server
Group: Development/Python
BuildArch: noarch
Requires: %name-server-common = %version-%release
Requires: %name-common = %version-%release
Requires: python-module-ipaclient = %version-%release
Requires: python-module-ipaserver-ntp = %version-%release
# Explicitly require python-module-samba
# to avoid conflict with python-module-samba-DC
Requires: python-module-samba
Requires: zip

%description -n python-module-ipaserver
IPA is an integrated solution to provide centrally managed Identity
(users, hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution
provides features for further integration with Linux based clients
(SUDO, automount) and integration with Active Directory based
infrastructures (Trusts).
If you are installing an IPA server, you need to install this package.

###############################################################################

%package server-common
Summary: Common files used by IPA server
Group: System/Base
BuildArch: noarch
Requires: %name-client-common = %version-%release
Requires: apache2-base webserver-common
Requires: custodia
Requires: fonts-font-awesome
Requires: fonts-ttf-open-sans

%description server-common
IPA is an integrated solution to provide centrally managed Identity
(users, hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution
provides features for further integration with Linux based clients
(SUDO, automount) and integration with Active Directory based
infrastructures (Trusts).
If you are installing an IPA server, you need to install this package.

###############################################################################

%package server-dns
Summary: IPA integrated DNS server
Group: System/Base
BuildArch: noarch
Requires: %name-server = %version-%release
Requires: bind-dyndb-ldap
Requires: bind >= 9.10.4
Requires: bind-utils
#Requires: bind-pkcs11
#Requires: bind-pkcs11-utils
#Requires: opendnssec

%description server-dns
IPA integrated DNS server.
Integrated DNS server is BIND 9.

###############################################################################

%package server-trust-ad
Summary: Virtual package to install packages required for Active Directory trusts
Group: System/Base
Requires: %name-server = %version-%release
Requires: samba samba-winbind
Requires: python-module-sss-murmur

%description server-trust-ad
Cross-realm trusts with Active Directory in IPA require working Samba 4
installation. This package is provided for convenience to install all
required dependencies at once.

###############################################################################

%package client
Summary: IPA authentication for use on clients
Group: System/Base
Requires: %name-client-common = %version-%release
Requires: python-module-%name = %version-%release
Requires: python-module-ipaclient = %version-%release
Requires: oddjob-mkhomedir
Requires: sssd-krb5 >= %sssd_version
Requires: sssd-ipa >= %sssd_version
Requires: python-module-sssdconfig >= %sssd_version
Requires: libsss_sudo >= %sssd_version
Requires: krb5-kinit >= %krb5_version
Requires: certmonger >= 0.79.5
Requires: nss-utils
Requires: bind-utils

%description client
IPA is an integrated solution to provide centrally managed Identity
(machine, user, virtual machines, groups, authentication credentials),
Policy (configuration settings, access control information) and Audit
(events, logs, analysis thereof).
If your network uses IPA for authentication, this package should be
installed on every client machine.

###############################################################################

%package client-automount
Summary: IPA Automount for use on clients
Group: System/Base
BuildArch: noarch
Requires: %name-client = %version-%release
Requires: autofs-sss
Requires: libsss_autofs
Requires: sssd-nfs-idmap

%description client-automount
IPA is an integrated solution to provide centrally managed Identity
(machine, user, virtual machines, groups, authentication credentials),
Policy (configuration settings, access control information) and Audit
(events, logs, analysis thereof).
If your network uses IPA for authentication and you would like to use
Automount, this package should be installed.

###############################################################################

%package -n python-module-ipaclient
Summary: Python module for IPA client
Group: Development/Python
BuildArch: noarch
Requires: python-module-ipaclient-ntp = %version-%release

%description -n python-module-ipaclient
IPA is an integrated solution to provide centrally managed Identity
(users, hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution
provides features for further integration with Linux based clients
(SUDO, automount) and integration with Active Directory based
infrastructures (Trusts).
If your network uses IPA for authentication, this package should be
installed on every client machine.

###############################################################################

%package client-common
Summary: Common files used by IPA client
Group: System/Base
BuildArch: noarch
Requires: %name-common = %version-%release

%description client-common
IPA is an integrated solution to provide centrally managed Identity
(users, hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution
provides features for further integration with Linux based clients
(SUDO, automount) and integration with Active Directory based
infrastructures (Trusts).
If your network uses IPA for authentication, this package should be
installed on every client machine.

###############################################################################

%package admintools
Summary: IPA administrative tools
Group: System/Base
BuildArch: noarch
Requires: python-module-%name = %version-%release
Requires: %name-client-common = %version-%release

%description admintools
IPA is an integrated solution to provide centrally managed Identity
(machine, user, virtual machines, groups, authentication credentials),
Policy (configuration settings, access control information) and Audit
(events, logs, analysis thereof).
This package provides command-line tools for IPA administrators.

###############################################################################

%package -n python-module-freeipa
Summary: Python libraries used by IPA
Group: Development/Python
BuildArch: noarch
Requires: %name-common = %version-%release
Requires: gnupg
Requires: keyutils
Requires: curl
Requires: openssl

# Drop %%python_sitelibdir_noarch from requires.
# Otherwise it will be removed by the dependency optimizator
# on i586, but not on x86_64 and noarch check will fail.
%filter_from_requires /^\/usr\/lib\/python[[:digit:].]\+\/site-packages$/d

%description -n python-module-freeipa
IPA is an integrated solution to provide centrally managed Identity (machine,
user, virtual machines, groups, authentication credentials), Policy
(configuration settings, access control information) and Audit (events,
logs, analysis thereof). If you are using IPA you need to install this
package.

###############################################################################

%package -n python-module-ipaserver-ntp
Summary: Python IPA libraries for ntp services in IPA server
Group: Development/Python
BuildArch: noarch

%description -n python-module-ipaserver-ntp
IPA libraries for synchronization IPA server with time&data servers.

###############################################################################

%package -n python-module-ipaclient-ntp
Summary: Python IPA libraries for ntp services in IPA client
Group: Development/Python
BuildArch: noarch

%description -n python-module-ipaclient-ntp
IPA libraries for synchronization IPA client with time&data servers.

###############################################################################

%package common
Summary: Common files used by IPA
Group: System/Base
BuildArch: noarch

%description common
IPA is an integrated solution to provide centrally managed Identity (users,
hosts, services), Authentication (SSO, 2FA), and Authorization
(host access control, SELinux user roles, services). The solution provides
features for further integration with Linux based clients (SUDO, automount)
and integration with Active Directory based infrastructures (Trusts).
If you are using IPA, you need to install this package.

###############################################################################

%package tests
Summary: IPA tests and test tools
Group: System/Base
Requires: %name-client-common = %version-%release
Requires: python-module-%name = %version-%release
BuildArch: noarch

%description tests
IPA is an integrated solution to provide centrally managed Identity (machine,
user, virtual machines, groups, authentication credentials), Policy
(configuration settings, access control information) and Audit (events,
logs, analysis thereof).
This package contains tests that verify IPA functionality.

###############################################################################

%prep
%setup -n freeipa-%version
%patch -p1

%build
export JAVA_STACK_SIZE="8m"
export CFLAGS="$CFLAGS %optflags -I/usr/include/krb5"
export CPPFLAGS="$CPPFLAGS %optflags -I/usr/include/krb5"
export SUPPORTED_PLATFORM=altlinux
# Force re-generate of platform support
rm -f ipapython/services.py
%make SKIP_API_VERSION_CHECK="yes" PYTHON="python" version-update
# cd ipa-client; ../autogen.sh --prefix=%_usr --sysconfdir=%_sysconfdir --localstatedir=%_localstatedir --libdir=%_libdir --mandir=%_mandir; cd ..
pushd client
	%autoreconf
	%configure
popd
#cd daemons; ../autogen.sh --prefix=%_usr --sysconfdir=%_sysconfdir --localstatedir=%_localstatedir --libdir=%_libdir --mandir=%_mandir --with-openldap; cd ..
pushd daemons
	%autoreconf
	# Workaround for 389-ds-devel-1.3.6.4-alt1:
	# there config.h included in the public header and
	# check the headers existence is not possible.
	export ac_cv_header_dirsrv_slapi_plugin_h=yes
	export ac_cv_header_dirsrv_repl_session_plugin_h=yes
	%configure --with-openldap
popd
#cd install; ../autogen.sh --prefix=%_usr --sysconfdir=%_sysconfdir --localstatedir=%_localstatedir --libdir=%_libdir --mandir=%_mandir; cd ..
pushd install
	%autoreconf
	%configure
popd

%make_build IPA_VERSION_IS_GIT_SNAPSHOT=no SKIP_API_VERSION_CHECK="yes" PYTHON="python" all

%install
export SUPPORTED_PLATFORM=altlinux
# Force re-generate of platform support
rm -f ipapython/services.py
%makeinstall_std SKIP_API_VERSION_CHECK="yes" PYTHON="python"
install -Dm0644 %SOURCE1 %buildroot%apache_conf_dir/mods-available/ipa-nss.conf
install -Dm0644 %SOURCE3 %buildroot%apache_conf_dir/mods-available/ipa-nss.load
install -Dm0755 %SOURCE2 %buildroot%_sbindir/ipa_configured
%find_lang ipa

# [ "/usr/lib/python2.7/site-packages" != "%python_sitelibdir" ] && mv %buildroot/usr/lib/python2.7/site-packages/* %buildroot/%python_sitelibdir/

rm -f %buildroot/%plugin_dir/*.la
rm -f %buildroot%_libdir/krb5/plugins/kdb/ipadb.la
rm -f %buildroot%_libdir/samba/pdb/ipasam.la

# Some user-modifiable HTML files are provided. Move these to /etc
# and link back.
mkdir -p %buildroot/%_sysconfdir/ipa/html
mkdir %buildroot%_datadir/ipa/html/
ln -s ../../../..%_sysconfdir/ipa/html/ffconfig.js \
    %buildroot%_datadir/ipa/html/ffconfig.js
ln -s ../../../..%_sysconfdir/ipa/html/ffconfig_page.js \
    %buildroot%_datadir/ipa/html/ffconfig_page.js
ln -s ../../../..%_sysconfdir/ipa/html/ssbrowser.html \
    %buildroot%_datadir/ipa/html/ssbrowser.html
ln -s ../../../..%_sysconfdir/ipa/html/unauthorized.html \
    %buildroot%_datadir/ipa/html/unauthorized.html
ln -s ../../../..%_sysconfdir/ipa/html/browserconfig.html \
    %buildroot%_datadir/ipa/html/browserconfig.html

# So we can own our Apache configuration
mkdir -p %buildroot%apache_conf_dir/{sites-available,extra-available,extra-enabled}
touch %buildroot%apache_conf_dir/sites-available/ipa.conf
touch %buildroot%apache_conf_dir/extra-enabled/ipa-kdc-proxy.conf
touch %buildroot%apache_conf_dir/extra-enabled/ipa-pki-proxy.conf
touch %buildroot%apache_conf_dir/ipa-rewrite.conf
mkdir -p %buildroot%_datadir/ipa/html/
touch %buildroot%_datadir/ipa/html/ca.crt
touch %buildroot%_datadir/ipa/html/configure.jar
touch %buildroot%_datadir/ipa/html/kerberosauth.xpi
touch %buildroot%_datadir/ipa/html/krb.con
touch %buildroot%_datadir/ipa/html/krb.js
touch %buildroot%_datadir/ipa/html/krb5.ini
touch %buildroot%_datadir/ipa/html/krbrealm.con
touch %buildroot%_datadir/ipa/html/preferences.html
mkdir -p %buildroot%_initdir
mkdir %buildroot%_sysconfdir/sysconfig/
install -m 644 init/ipa_memcached.conf %buildroot%_sysconfdir/sysconfig/ipa_memcached
#install -m 644 init/ipa-dnskeysyncd.conf %buildroot%_sysconfdir/sysconfig/ipa-dnskeysyncd
#install -m 644 init/ipa-ods-exporter.conf %buildroot%_sysconfdir/sysconfig/ipa-ods-exporter
#install -m 644 daemons/dnssec/ipa-ods-exporter.socket %buildroot%_unitdir/ipa-ods-exporter.socket
#install -m 644 daemons/dnssec/ipa-ods-exporter.service %buildroot%_unitdir/ipa-ods-exporter.service
#install -m 644 daemons/dnssec/ipa-dnskeysyncd.service %buildroot%_unitdir/ipa-dnskeysyncd.service

# dnssec daemons
mkdir -p %buildroot/usr/libexec/ipa/
#install daemons/dnssec/ipa-dnskeysyncd %buildroot%_libexecdir/ipa/ipa-dnskeysyncd
#install daemons/dnssec/ipa-dnskeysync-replica %buildroot%_libexecdir/ipa/ipa-dnskeysync-replica
#install daemons/dnssec/ipa-ods-exporter %buildroot%_libexecdir/ipa/ipa-ods-exporter

# Web UI plugin dir
mkdir -p %buildroot%_datadir/ipa/ui/js/plugins

# DNSSEC config
#mkdir -p %buildroot%_sysconfdir/ipa/dnssec

# KDC proxy config (Apache config sets KDCPROXY_CONFIG to load this file)
mkdir -p %buildroot%_sysconfdir/ipa/kdcproxy/
mkdir -p %buildroot%_sharedstatedir/kdcproxy/
install -m 644 install/share/kdcproxy.conf %buildroot%_sysconfdir/ipa/kdcproxy/kdcproxy.conf
touch %buildroot%_sysconfdir/ipa/kdcproxy/ipa-kdc-proxy.conf

# NOTE: systemd specific section
mkdir -p %buildroot/lib/tmpfiles.d
install -m 0644 init/systemd/ipa.conf.tmpfiles %buildroot/lib/tmpfiles.d/%name.conf
# END

mkdir -p %buildroot%_runtimedir
install -d -m 0700 %buildroot%_runtimedir/ipa_memcached/
install -d -m 0700 %buildroot%_runtimedir/ipa/
install -d -m 0700 %buildroot%_runtimedir/httpd2/ipa
install -d -m 0700 %buildroot%_runtimedir/httpd2/ipa/clientcaches
install -d -m 0700 %buildroot%_runtimedir/run/httpd2/ipa/krbcache

#mkdir -p %{buildroot}%{_libdir}/krb5/plugins/libkrb5
#touch %{buildroot}%{_libdir}/krb5/plugins/libkrb5/winbind_krb5_locator.so

# NOTE: systemd specific section
mkdir -p %buildroot%_unitdir
mkdir -p %buildroot%etc_systemd_dir
install -m 644 init/systemd/ipa.service %buildroot%_unitdir/ipa.service
install -m 644 init/systemd/ipa_memcached.service %buildroot%_unitdir/ipa_memcached.service
install -m 644 init/systemd/httpd.service %buildroot%etc_systemd_dir/httpd2.service
install -m 644 init/systemd/ipa-custodia.service %buildroot%_unitdir/ipa-custodia.service
# END
mkdir -p %buildroot%_localstatedir/lib/ipa/backup

touch %buildroot%_sysconfdir/ipa/default.conf
touch %buildroot%_sysconfdir/ipa/ca.crt
mkdir -p %buildroot%_sysconfdir/ipa/nssdb
touch %buildroot%_sysconfdir/ipa/nssdb/cert8.db
touch %buildroot%_sysconfdir/ipa/nssdb/key3.db
touch %buildroot%_sysconfdir/ipa/nssdb/secmod.db
touch %buildroot%_sysconfdir/ipa/nssdb/pwdfile.txt
mkdir -p %buildroot%_localstatedir/lib/ipa-client/sysrestore

mkdir -p %buildroot%_sysconfdir/bash_completion.d
install -pm 644 contrib/completion/ipa.bash_completion %buildroot%_sysconfdir/bash_completion.d/ipa
mkdir -p %buildroot%_sysconfdir/cron.d

mkdir -p %buildroot%_sysconfdir/ipa/custodia

mkdir -p %buildroot%_localstatedir/lib/ipa/pki-ca
touch %buildroot%_localstatedir/lib/ipa/pki-ca/publish

mkdir -p %buildroot%_sysconfdir/pki/ca-trust/source/
touch %buildroot%_sysconfdir/pki/ca-trust/source/ipa.p11-kit

mkdir -p %buildroot%_rpmlibdir
install -D -p -m 0755 %SOURCE4 %buildroot%_rpmlibdir/freeipa-server.filetrigger

%check
%make check VERBOSE=yes

%files server
%doc COPYING README Contributors.txt
%_sbindir/*

%exclude %_sbindir/ipa-adtrust-install
%exclude %_sbindir/ipa-client-*
%exclude %_sbindir/ipa-*keytab
%exclude %_sbindir/ipa-join
%exclude %_sbindir/ipa-certupdate
%exclude %_sbindir/ipa-dns-install
%exclude %_sbindir/ipa_configured

%_libexecdir/certmonger/dogtag-ipa-ca-renew-agent-submit
%_libexecdir/certmonger/ipa-server-guard
%_libexecdir/ipa-otpd
%dir %_libexecdir/ipa/
#%_libexecdir/ipa/ipa-dnskeysyncd
#%_libexecdir/ipa/ipa-dnskeysync-replica
#%_libexecdir/ipa/ipa-ods-exporter
%_libexecdir/ipa/ipa-httpd-kdcproxy
%dir %_libexecdir/ipa/oddjob/

%_libexecdir/ipa/oddjob/org.freeipa.server.conncheck
%_sysconfdir/dbus-1/system.d/org.freeipa.server.conf
%_sysconfdir/oddjobd.conf.d/ipa-server.conf
%dir %_libexecdir/ipa/certmonger
%attr(755,root,root) %_libexecdir/ipa/certmonger/*
# NOTE: systemd specific section
%attr(644,root,root) %_unitdir/ipa.service
%attr(644,root,root) %_unitdir/ipa-otpd.socket
%attr(644,root,root) %_unitdir/ipa-otpd@.service
#%attr(644,root,root) %_unitdir/ipa-dnskeysyncd.service
#%attr(644,root,root) %_unitdir/ipa-ods-exporter.socket
#%attr(644,root,root) %_unitdir/ipa-ods-exporter.service
# END

%plugin_dir/*.so

%_libdir/krb5/plugins/kdb/ipadb.so
%_man1dir/ipa-replica-conncheck.1.*
%_man1dir/ipa-replica-install.1.*
%_man1dir/ipa-replica-manage.1.*
%_man1dir/ipa-csreplica-manage.1.*
%_man1dir/ipa-replica-prepare.1.*
%_man1dir/ipa-server-certinstall.1.*
%_man1dir/ipa-server-install.1.*
%_man1dir/ipa-server-upgrade.1.*
%_man1dir/ipa-ca-install.1.*
%_man1dir/ipa-kra-install.1.*
%_man1dir/ipa-compat-manage.1.*
%_man1dir/ipa-nis-manage.1.*
%_man1dir/ipa-managed-entries.1.*
%_man1dir/ipa-ldap-updater.1.*
%_man8dir/ipactl.8.*
%_man8dir/ipa-upgradeconfig.8.*
%_man1dir/ipa-backup.1.*
%_man1dir/ipa-restore.1.*
%_man1dir/ipa-advise.1.*
%_man1dir/ipa-otptoken-import.1.*
%_man1dir/ipa-cacert-manage.1.*
%_man1dir/ipa-winsync-migrate.1.*

%_rpmlibdir/freeipa-server.filetrigger

%files -n python-module-ipaserver
%python_sitelibdir_noarch/freeipa-*.egg-info
%python_sitelibdir_noarch/ipaserver

%exclude %python_sitelibdir_noarch/ipaserver/install/servntpconf*
%exclude %python_sitelibdir_noarch/ipaserver/install/servntplib*

%files -n python-module-ipaserver-ntp
%python_sitelibdir_noarch/ipaserver/install/servntpconf*
%python_sitelibdir_noarch/ipaserver/install/servntplib*

%files server-common
%_sbindir/ipa_configured
%ghost %verify(not user group) %dir %_sharedstatedir/kdcproxy
%dir %attr(0755,root,root) %_sysconfdir/ipa/kdcproxy
%config(noreplace) %_sysconfdir/sysconfig/ipa_memcached
#%config(noreplace) %_sysconfdir/sysconfig/ipa-dnskeysyncd
#%config(noreplace) %_sysconfdir/sysconfig/ipa-ods-exporter
%config(noreplace) %_sysconfdir/ipa/kdcproxy/kdcproxy.conf
%dir %attr(0700,apache2,apache2) %_runtimedir/ipa_memcached
%attr(0700,apache2,apache2) %_runtimedir/httpd2/ipa/
# NOTE: systemd specific section
%_tmpfilesdir/%name.conf
%attr(644,root,root) %_unitdir/ipa_memcached.service
%attr(644,root,root) %_unitdir/ipa-custodia.service
%attr(644,root,root) %etc_systemd_dir/httpd2.service
# END
%_datadir/ipa/*
%exclude %_datadir/ipa/smb.conf.empty
%ghost %attr(0644,root,%webserver_group) %config(noreplace) %_datadir/ipa/html/ca.crt
%ghost %attr(0644,root,%webserver_group) %_datadir/ipa/html/configure.jar
%ghost %attr(0644,root,%webserver_group) %_datadir/ipa/html/kerberosauth.xpi
%ghost %attr(0644,root,%webserver_group) %_datadir/ipa/html/krb.con
%ghost %attr(0644,root,%webserver_group) %_datadir/ipa/html/krb.js
%ghost %attr(0644,root,%webserver_group) %_datadir/ipa/html/krb5.ini
%ghost %attr(0644,root,%webserver_group) %_datadir/ipa/html/krbrealm.con
%ghost %attr(0644,root,%webserver_group) %_datadir/ipa/html/preferences.html
%dir %_sysconfdir/ipa
%dir %_sysconfdir/ipa/html
%config(noreplace) %attr(0644,root,%webserver_group) %_sysconfdir/ipa/html/*

%config(noreplace) %apache_conf_dir/mods-available/ipa-nss.conf
%config %apache_conf_dir/mods-available/ipa-nss.load
%ghost %attr(0644,root,%webserver_group) %config(noreplace) %apache_conf_dir/ipa-rewrite.conf
%ghost %attr(0644,root,%webserver_group) %config(noreplace) %apache_conf_dir/sites-available/ipa.conf
%ghost %attr(0644,root,%webserver_group) %config(noreplace) %apache_conf_dir/extra-enabled/ipa-pki-proxy.conf
%ghost %attr(0644,root,%webserver_group) %config(noreplace) %apache_conf_dir/extra-enabled/ipa-kdc-proxy.conf
%ghost %attr(0644,root,apache2) %config(noreplace) %_sysconfdir/ipa/kdcproxy/ipa-kdc-proxy.conf
#%dir %attr(0755,root,root) %_sysconfdir/ipa/dnssec
%dir %_localstatedir/lib/ipa

%attr(700,root,root) %dir %_localstatedir/lib/ipa/backup
%attr(700,root,root) %dir %_localstatedir/lib/ipa/sysrestore
%attr(700,root,root) %dir %_localstatedir/lib/ipa/sysupgrade
%attr(755,root,root) %dir %_localstatedir/lib/ipa/pki-ca
%ghost %_localstatedir/lib/ipa/pki-ca/publish
#%ghost %_localstatedir/lib/bind/zone/dyndb-ldap/ipa
#%ghost %_localstatedir/lib/bind/zone/dyndb-ldap/ipa/master
%dir %attr(0700,root,root) %_sysconfdir/ipa/custodia

# DNSSEC is disabled for now
%exclude %_datadir/ipa/dnssec.ldif
%exclude %_datadir/ipa/opendnssec_conf.template
%exclude %_datadir/ipa/opendnssec_kasp.template

# This should be run from posttrans actually (or from filetrigger if posttrans
# is not available).
# But for now just run it in post, this shouldn't cause any damage.
#posttrans server
%post server
systemctl --system daemon-reload 2>&1 ||:

%post_service ipa
%post_service certmonger
%post_service dbus
%post_service oddjobd

%preun server
%preun_service ipa
 
if [ $1 = 0 ]; then
    /bin/systemctl reload-or-try-restart dbus ||:
    /bin/systemctl reload-or-try-restart oddjobd ||:
fi

%triggerun server-common -- freeipa-server-common <= 4.3.3-alt3
if ipa_configured; then
	for A_CONF in ipa-pki-proxy.conf ipa-kdc-proxy.conf; do
		if [ -f  %apache_conf_dir/"$A_CONF" ] || [ -L  %apache_conf_dir/"$A_CONF" ]; then
			mv -n %apache_conf_dir/"$A_CONF" %apache_conf_dir/extra-enabled/"$A_CONF" ||:
		fi
	done
	a2enmod proxy_ajp >/dev/null 2>&1 ||:
	a2enmod proxy_http >/dev/null 2>&1 ||:

	a2disextra ipa-nss >/dev/null 2>&1 ||:
	mv -f %apache_conf_dir/extra-available/ipa-nss.conf %apache_conf_dir/mods-available/ipa-nss.conf ||:
fi

%triggerpostun server-common -- freeipa-server-common <= 4.3.3-alt3
if ipa_configured; then
	a2dismod nss >/dev/null 2>&1 ||:
	a2enmod ipa-nss >/dev/null 2>&1 ||:

	if systemctl is-enabled httpd2.service >/dev/null 2>&1; then
		systemctl try-restart httpd2.service >/dev/null 2>&1 ||:
	fi
fi

# Update ipa.conf for new fontawesome path.
%triggerpostun server-common -- freeipa-server-common <= 4.3.3-alt6
if ipa_configured; then
	# Create new ipa.conf from template:
	# this much simpler then edit existing ipa.conf
	TMP_FILE="$(mktemp /etc/httpd2/conf/sites-available/ipa.conf.XXXXXX)"
	if [ -n "$TMP_FILE" ]; then
		cp -Z /usr/share/ipa/ipa.conf "$TMP_FILE" ||:
		sed -i 's|\$CRL_PUBLISH_PATH|/var/lib/ipa/pki-ca/publish|' "$TMP_FILE" ||:
		mv -f "$TMP_FILE" /etc/httpd2/conf/sites-available/ipa.conf ||:

		if systemctl is-enabled httpd2.service >/dev/null 2>&1; then
			systemctl try-restart httpd2.service >/dev/null 2>&1 ||:
		fi
	fi
fi

%files server-dns
%_sbindir/ipa-dns-install
%_man1dir/ipa-dns-install.1.*

%files server-trust-ad
%_sbindir/ipa-adtrust-install
%_datadir/ipa/smb.conf.empty
%_libdir/samba/pdb/ipasam.so
%_man1dir/ipa-adtrust-install.1.*
%_sysconfdir/dbus-1/system.d/oddjob-ipa-trust.conf
%_sysconfdir/oddjobd.conf.d/oddjobd-ipa-trust.conf
%_libexecdir/ipa/oddjob/com.redhat.idm.trust-fetch-domains

%files client
%_sbindir/ipa-client-install
%_sbindir/ipa-*keytab
%_sbindir/ipa-join
%_sbindir/ipa-certupdate
#_datadir/ipa/ipaclient
%_man1dir/ipa-getkeytab.1.*
%_man1dir/ipa-rmkeytab.1.*
%_man1dir/ipa-client-install.1.*
%_man1dir/ipa-join.1.*
%_man1dir/ipa-certupdate.1.*

%files client-automount
%_sbindir/ipa-client-automount
%_man1dir/ipa-client-automount.1.*

%files -n python-module-ipaclient
%dir %python_sitelibdir_noarch/ipaclient
%python_sitelibdir_noarch/ipaclient/*.py*
%python_sitelibdir_noarch/ipaclient-*.egg-info

%exclude %python_sitelibdir_noarch/ipaclient/clintpconf*
%exclude %python_sitelibdir_noarch/ipaclient/clintplib*

%files -n python-module-ipaclient-ntp
%python_sitelibdir_noarch/ipaclient/clintpconf*
%python_sitelibdir_noarch/ipaclient/clintplib*

%files client-common
%dir %attr(0700,root,root) %_runtimedir/ipa
%ghost %attr(0644,root,%webserver_group) %config(noreplace) %_sysconfdir/ipa/default.conf
%ghost %attr(0644,root,%webserver_group) %config(noreplace) %_sysconfdir/ipa/ca.crt
%dir %_sysconfdir/ipa/nssdb
%ghost %config(noreplace) %_sysconfdir/ipa/nssdb/cert8.db
%ghost %config(noreplace) %_sysconfdir/ipa/nssdb/key3.db
%ghost %config(noreplace) %_sysconfdir/ipa/nssdb/secmod.db
%ghost %config(noreplace) %_sysconfdir/ipa/nssdb/pwdfile.txt
%ghost %config(noreplace) %_sysconfdir/pki/ca-trust/source/ipa.p11-kit
%dir %_localstatedir/lib/ipa-client
%dir %_localstatedir/lib/ipa-client/sysrestore
%_man5dir/default.conf.5.*

%files admintools
%_bindir/ipa
%config %_sysconfdir/bash_completion.d
%_man1dir/ipa.1.*

%files -n python-module-freeipa
%python_sitelibdir_noarch/ipapython
%python_sitelibdir_noarch/ipalib
%python_sitelibdir_noarch/ipaplatform
%python_sitelibdir_noarch/ipaplatform-*.egg-info
%python_sitelibdir_noarch/ipapython-*.egg-info
%python_sitelibdir_noarch/ipalib-*.egg-info

%files common -f ipa.lang
%doc README Contributors.txt
%dir %_sysconfdir/ipa/
%dir %_datadir/ipa

%files tests
%python_sitelibdir_noarch/ipatests
%_bindir/ipa-run-tests
%_bindir/ipa-test-config
%_bindir/ipa-test-task
%python_sitelibdir_noarch/ipatests-*.egg-info
%_man1dir/ipa-run-tests.1.*
%_man1dir/ipa-test-config.1.*
%_man1dir/ipa-test-task.1.*


%changelog
