Summary: High-performance and highly configurable free RADIUS server
Name: freeradius
Version: 2.2.9
Release: alt2
License: GPLv2+ and LGPLv2+
Group: System/Servers
Url: http://www.freeradius.org/

# Cloned from git://git.freeradius.org/freeradius-server.git
Source0: %name-%version.tar
Source100: freeradius-radiusd-init
Source102: freeradius-logrotate
Source103: freeradius-pam-conf
Source104: freeradius-tmpfiles
Source105: freeradius-service

Patch1: %name-%version-%release.patch

BuildRequires: gcc-c++ libmysqlclient-devel libcom_err-devel libgdbm-devel libldap-devel libltdl-devel libpam-devel libreadline-devel libstdc++-devel-static libunixODBC-devel mailx net-snmp-utils perl-DBI perl-devel postgresql-devel python-devel slocate libssl-devel perl-DBM

# Server needs dicts and /etc/raddb to work:
Requires: %name-common

%description
The FreeRADIUS Server Project is a high performance and highly configurable
GPL'd free RADIUS server. The server is similar in some respects to
Livingston's 2.0 server.  While FreeRADIUS started as a variant of the
Cistron RADIUS server, they don't share a lot in common any more. It now has
many more features than Cistron or Livingston, and is much more configurable.

FreeRADIUS is an Internet authentication daemon, which implements the RADIUS
protocol, as defined in RFC 2865 (and others). It allows Network Access
Servers (NAS boxes) to perform authentication for dial-up users. There are
also RADIUS clients available for Web servers, firewalls, Unix logins, and
more.  Using RADIUS allows authentication and authorization for a network to
be centralized, and minimizes the amount of re-configuration which has to be
done when adding or deleting new users.

%package common
Group: System/Servers
Summary: FreeRADIUS common data
# For now this subpackage contains only dicts (arch-independent):
BuildArch: noarch
# Alias for convience:
Provides: %name-dictionary = %version-%release

%description common
The FreeRADIUS common data

%package libs
Group: System/Servers
Summary: FreeRADIUS shared libraries

%description libs
The FreeRADIUS shared library

%package utils
Group: System/Servers
Summary: FreeRADIUS utilities
Requires: %name-libs = %version-%release
# Radius client(s) need dicts to work:
Requires: %name-dictionary = %version-%release

%description utils
The FreeRADIUS server has a number of features found in other servers,
and additional features not found in any other server. Rather than
doing a feature by feature comparison, we will simply list the features
of the server, and let you decide if they satisfy your needs.

Support for RFC and VSA Attributes Additional server configuration
attributes Selecting a particular configuration Authentication methods

%package devel
Group: Development/C
Summary: FreeRADIUS Development Files
Requires: %name-libs = %version-%release

%description devel
These are the static libraries for the FreeRADIUS package.

%package ldap
Summary: LDAP support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description ldap
This plugin provides the LDAP support for the FreeRADIUS server project.

%package krb5
Summary: Kerberos 5 support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description krb5
This plugin provides the Kerberos 5 support for the FreeRADIUS server project.

%package perl
Summary: Perl support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release


%description perl
This plugin provides the Perl support for the FreeRADIUS server project.

%package python
Summary: Python support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description python
This plugin provides the Python support for the FreeRADIUS server project.

%package mysql
Summary: MySQL support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description mysql
This plugin provides the MySQL support for the FreeRADIUS server project.

%package postgresql
Summary: postgresql support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description postgresql
This plugin provides the postgresql support for the FreeRADIUS server project.

%package unixODBC
Summary: unixODBC support for freeradius
Group: System/Servers
Requires: %name-libs = %version-%release

%description unixODBC
This plugin provides the unixODBC support for the FreeRADIUS server project.

%prep
%setup -q
%patch1 -p1

%build
%configure \
        --with-system-libtool \
        --with-system-libltdl \
        --localstatedir=/var \
        --libdir=%_libdir/freeradius \
        --disable-ltdl-install \
        --disable-static \
        --with-gnu-ld \
        --with-threads \
        --with-thread-pool \
        --with-docdir=%_docdir/freeradius-%version \
        --with-rlm-sql_postgresql-include-dir=/usr/include/pgsql \
        --with-rlm-sql-postgresql-lib-dir=%_libdir \
        --with-rlm-sql_mysql-include-dir=/usr/include/mysql \
        --with-mysql-lib-dir=%_libdir/mysql \
        --with-unixodbc-lib-dir=%_libdir \
        --with-rlm-dbm-lib-dir=%_libdir \
        --with-rlm-krb5-include-dir=/usr/include/krb5 \
        --without-rlm_eap_ikev2 \
        --without-rlm_sql_iodbc \
        --without-rlm_sql_firebird \
        --without-rlm_sql_db2 \
        --without-rlm_sql_oracle

%make_build

%install
make install R=%buildroot

# modify default configuration
RADDB=%buildroot%_sysconfdir/raddb
sed -i 's/^#user =.*$/user = radiusd/'   $RADDB/radiusd.conf
sed -i 's/^#group =.*$/group = radiusd/' $RADDB/radiusd.conf
# logs
mkdir -p %buildroot%_logdir/radius/radacct
touch %buildroot%_logdir/radius/{radutmp,radius.log}

mkdir -p %buildroot%_runtimedir/radiusd
mkdir -p %buildroot%_sysconfdir/{logrotate.d,pam.d,rc.d/init.d}
mkdir -p %buildroot%_tmpfilesdir
mkdir -p %buildroot%_unitdir
mkdir -p %buildroot%_localstatedir/radiusd
install -m 755 %SOURCE100 %buildroot%_initdir/radiusd
install -m 644 %SOURCE102 %buildroot%_sysconfdir/logrotate.d/radiusd
install -m 644 %SOURCE103 %buildroot%_sysconfdir/pam.d/radiusd
install -m 644 %SOURCE104 %buildroot%_tmpfilesdir/radiusd.conf
install -m 644 %SOURCE105 %buildroot%_unitdir/radiusd.service

# remove unneeded stuff
rm %buildroot%_sbindir/rc.radiusd
rm %buildroot%_libdir/freeradius/*.a
rm %buildroot%_libdir/freeradius/*.la
rm -r %buildroot%_sysconfdir/raddb/sql/mssql
rm -r %buildroot%_sysconfdir/raddb/sql/oracle

# remove unsupported config files
rm %buildroot/%_sysconfdir/raddb/experimental.conf

%pre common
/usr/sbin/groupadd -r -f radiusd
/usr/sbin/useradd -r -n -g radiusd -d /dev/null -s /dev/null -c RADIUS radiusd >/dev/null 2>&1 ||:

%post
%post_service radiusd
if [ $1 = 1 ]; then
    if [ ! -e /etc/raddb/certs/server.pem ]; then
        su -s "/bin/sh" -c "/etc/raddb/certs/bootstrap" radiusd > /dev/null 2>&1 || :
    fi
fi

%preun
%preun_service radiusd

%files
%doc %_docdir/freeradius-%version/
%config(noreplace) %_sysconfdir/pam.d/radiusd
%config(noreplace) %_sysconfdir/logrotate.d/radiusd
%config(noreplace) %_initdir/radiusd
%_unitdir/radiusd.service
%_tmpfilesdir/radiusd.conf
%dir %attr(775,root,radiusd) %_localstatedir/radiusd
# configs
%defattr(-,root,radiusd)
%config(noreplace) %_sysconfdir/raddb/acct_users
%config(noreplace) %_sysconfdir/raddb/attrs
%config(noreplace) %_sysconfdir/raddb/attrs.access_challenge
%config(noreplace) %_sysconfdir/raddb/attrs.access_reject
%config(noreplace) %_sysconfdir/raddb/attrs.accounting_response
%config(noreplace) %_sysconfdir/raddb/attrs.pre-proxy
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/clients.conf
%config(noreplace) %_sysconfdir/raddb/hints
%config(noreplace) %_sysconfdir/raddb/huntgroups
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sqlippool.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/preproxy_users
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/proxy.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/radiusd.conf
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sql.conf
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/sql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/users
%dir %attr(770,root,radiusd) %_sysconfdir/raddb/certs
%_sysconfdir/raddb/certs/Makefile
%_sysconfdir/raddb/certs/README
%_sysconfdir/raddb/certs/xpextensions
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/certs/*.cnf
%attr(750,root,radiusd) %_sysconfdir/raddb/certs/bootstrap
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/sites-available
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sites-available/*
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/sites-enabled
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sites-enabled/*
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/eap.conf
%attr(640,root,radiusd) %_sysconfdir/raddb/example.pl
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/policy.conf
%_sysconfdir/raddb/policy.txt
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/templates.conf
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/modules
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/acct_unique
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/always
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/attr_filter
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/attr_rewrite
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/cache
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/chap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/checkval
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/counter
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/cui
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/detail
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/detail.example.com
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/detail.log
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/digest
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/dynamic_clients
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/echo
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/etc_group
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/exec
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/expiration
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/expr
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/files
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/inner-eap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/ippool
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/logintime
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/linelog
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/mac2ip
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/mac2vlan
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/mschap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/ntlm_auth
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/opendirectory
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/otp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/pam
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/pap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/perl
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/passwd
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/policy
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/preprocess
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/radrelay
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/radutmp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/realm
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/redis
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/rediswho
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/replicate
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/smbpasswd
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/smsotp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/soh
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/sql_log
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/sqlcounter_expire_on_login
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/sradutmp
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/unix
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/wimax
%dir %attr(770,root,radiusd) %_runtimedir/radiusd/

%defattr(-,root,root)
# binaries
%_sbindir/checkrad
%_sbindir/raddebug
%_sbindir/radiusd
%_sbindir/radwatch
%_sbindir/radmin
# man-pages
%_man1dir/*
%_man5dir/*
%_man8dir/*
# logs
%dir %attr(1770,root,radiusd) %_logdir/radius/
%dir %attr(1770,root,radiusd) %_logdir/radius/radacct/
%config(noreplace) %attr(664,root,radiusd) %_logdir/radius/radutmp
%config(noreplace) %attr(660,radiusd,radiusd) %_logdir/radius/radius.log
# RADIUS Loadable Modules
%dir %_libdir/freeradius
%_libdir/freeradius/rlm_acct_unique.so
%_libdir/freeradius/rlm_acct_unique-%version.so
%_libdir/freeradius/rlm_acctlog.so
%_libdir/freeradius/rlm_acctlog-%version.so
%_libdir/freeradius/rlm_always.so
%_libdir/freeradius/rlm_always-%version.so
%_libdir/freeradius/rlm_attr_filter.so
%_libdir/freeradius/rlm_attr_filter-%version.so
%_libdir/freeradius/rlm_attr_rewrite.so
%_libdir/freeradius/rlm_attr_rewrite-%version.so
%_libdir/freeradius/rlm_cache.so
%_libdir/freeradius/rlm_cache-%version.so
%_libdir/freeradius/rlm_chap.so
%_libdir/freeradius/rlm_chap-%version.so
%_libdir/freeradius/rlm_checkval.so
%_libdir/freeradius/rlm_checkval-%version.so
%_libdir/freeradius/rlm_copy_packet.so
%_libdir/freeradius/rlm_copy_packet-%version.so
%_libdir/freeradius/rlm_counter.so
%_libdir/freeradius/rlm_counter-%version.so
%_libdir/freeradius/rlm_dbm.so
%_libdir/freeradius/rlm_dbm-%version.so
%_libdir/freeradius/rlm_detail.so
%_libdir/freeradius/rlm_detail-%version.so
%_libdir/freeradius/rlm_digest.so
%_libdir/freeradius/rlm_digest-%version.so
%_libdir/freeradius/rlm_dynamic_clients.so
%_libdir/freeradius/rlm_dynamic_clients-%version.so
%_libdir/freeradius/rlm_eap.so
%_libdir/freeradius/rlm_eap-%version.so
%_libdir/freeradius/rlm_eap_gtc.so
%_libdir/freeradius/rlm_eap_gtc-%version.so
%_libdir/freeradius/rlm_eap_leap.so
%_libdir/freeradius/rlm_eap_leap-%version.so
%_libdir/freeradius/rlm_eap_md5.so
%_libdir/freeradius/rlm_eap_md5-%version.so
%_libdir/freeradius/rlm_eap_mschapv2.so
%_libdir/freeradius/rlm_eap_mschapv2-%version.so
%_libdir/freeradius/rlm_eap_peap.so
%_libdir/freeradius/rlm_eap_peap-%version.so
%_libdir/freeradius/rlm_eap_sim.so
%_libdir/freeradius/rlm_eap_sim-%version.so
%_libdir/freeradius/rlm_eap_tls.so
%_libdir/freeradius/rlm_eap_tls-%version.so
%_libdir/freeradius/rlm_eap_ttls.so
%_libdir/freeradius/rlm_eap_ttls-%version.so
%_libdir/freeradius/rlm_exec.so
%_libdir/freeradius/rlm_exec-%version.so
%_libdir/freeradius/rlm_expiration.so
%_libdir/freeradius/rlm_expiration-%version.so
%_libdir/freeradius/rlm_expr.so
%_libdir/freeradius/rlm_expr-%version.so
%_libdir/freeradius/rlm_fastusers.so
%_libdir/freeradius/rlm_fastusers-%version.so
%_libdir/freeradius/rlm_files.so
%_libdir/freeradius/rlm_files-%version.so
%_libdir/freeradius/rlm_ippool.so
%_libdir/freeradius/rlm_ippool-%version.so
%_libdir/freeradius/rlm_linelog.so
%_libdir/freeradius/rlm_linelog-%version.so
%_libdir/freeradius/rlm_logintime.so
%_libdir/freeradius/rlm_logintime-%version.so
%_libdir/freeradius/rlm_mschap.so
%_libdir/freeradius/rlm_mschap-%version.so
%_libdir/freeradius/rlm_otp.so
%_libdir/freeradius/rlm_otp-%version.so
%_libdir/freeradius/rlm_pam.so
%_libdir/freeradius/rlm_pam-%version.so
%_libdir/freeradius/rlm_pap.so
%_libdir/freeradius/rlm_pap-%version.so
%_libdir/freeradius/rlm_passwd.so
%_libdir/freeradius/rlm_passwd-%version.so
%_libdir/freeradius/rlm_policy.so
%_libdir/freeradius/rlm_policy-%version.so
%_libdir/freeradius/rlm_preprocess.so
%_libdir/freeradius/rlm_preprocess-%version.so
%_libdir/freeradius/rlm_radutmp.so
%_libdir/freeradius/rlm_radutmp-%version.so
%_libdir/freeradius/rlm_realm.so
%_libdir/freeradius/rlm_realm-%version.so
%_libdir/freeradius/rlm_replicate.so
%_libdir/freeradius/rlm_replicate-%version.so
%_libdir/freeradius/rlm_soh.so
%_libdir/freeradius/rlm_soh-%version.so
%_libdir/freeradius/rlm_sql.so
%_libdir/freeradius/rlm_sql-%version.so
%_libdir/freeradius/rlm_sql_log.so
%_libdir/freeradius/rlm_sql_log-%version.so
%_libdir/freeradius/rlm_sqlcounter.so
%_libdir/freeradius/rlm_sqlcounter-%version.so
%_libdir/freeradius/rlm_sqlippool.so
%_libdir/freeradius/rlm_sqlippool-%version.so
%_libdir/freeradius/rlm_unix.so
%_libdir/freeradius/rlm_unix-%version.so
%_libdir/freeradius/rlm_wimax.so
%_libdir/freeradius/rlm_wimax-%version.so

%files common
%dir %attr(755,root,radiusd) %_sysconfdir/raddb
%attr(644,root,root) %config(noreplace) %_sysconfdir/raddb/dictionary
# dictionaries
%_datadir/freeradius

%files utils
%_bindir/*

%files libs
# RADIU shared libs
%_libdir/freeradius/lib*.so*

%files devel
%_includedir/freeradius

%files krb5
%_libdir/freeradius/rlm_krb5.so
%_libdir/freeradius/rlm_krb5-%version.so
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/krb5

%files perl
%_libdir/freeradius/rlm_perl.so
%_libdir/freeradius/rlm_perl-%version.so

%files python
%_libdir/freeradius/rlm_python.so
%_libdir/freeradius/rlm_python-%version.so

%files mysql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/dhcp_sqlippool
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/sql/mysql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sql/mysql/*
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/sql/ndb
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sql/ndb/*
%_libdir/freeradius/rlm_sql_mysql.so
%_libdir/freeradius/rlm_sql_mysql-%version.so

%files postgresql
%dir %attr(750,root,radiusd) %_sysconfdir/raddb/sql/postgresql
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/sql/postgresql/*
%_libdir/freeradius/rlm_sql_postgresql.so
%_libdir/freeradius/rlm_sql_postgresql-%version.so

%files ldap
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/ldap.attrmap
%_libdir/freeradius/rlm_ldap.so
%_libdir/freeradius/rlm_ldap-%version.so
%attr(640,root,radiusd) %config(noreplace) %_sysconfdir/raddb/modules/ldap

%files unixODBC
%_libdir/freeradius/rlm_sql_unixodbc.so
%_libdir/freeradius/rlm_sql_unixodbc-%version.so

%changelog
