# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
Name: frescobaldi
Version: 3.0.1
Release: alt0.M80P.1

Summary: LilyPond music score editor
License: %gpl2plus
Group: Publishing

Url: http://www.frescobaldi.org/

BuildRequires(pre): rpm-build-licenses

BuildRequires: ImageMagick-tools
BuildRequires: librsvg-utils python3-module-setuptools

BuildArch: noarch

Requires: lilypond

AutoProv:yes,nopython,nopython3

# Source-url: https://github.com/wbsoft/frescobaldi/archive/v%version.tar.gz
Source: %name-%version.tar

%description
Frescobaldi is a LilyPond music score editor, with following features:

* Enter LilyPond scores, build and preview them with a mouseclick
* Point-and-click support: click on notes or error messages to jump to the
  correct position
* A powerful Score Wizard to quickly setup a musical score
* Editing tools to:
  - manipulate the rhythm
  - hyphenate lyrics
  - quickly enter or add articulations and other symbols to existing music
  - run the document through convert-ly to update it to a newer LilyPond version
  - translate pitch names
* Context sensitive autocomplete, helping you to quickly enter LilyPond commands
* Expansion manager to enter larger snippets of LilyPond input using short
  mnemonics
* A powerful Rumor plugin, using the Rumor program to quickly enter music by
  playing it on a MIDI keyboard or even your computer keyboard
* Quick buttons to open, send, play or print LilyPond-generated files.
* Built-in comprehensive User Guide
* Translated into Dutch, English, French, German, Italian, Czech, Russian,
  Spanish, Turkish and Polish.

%prep
%setup

%build
%python3_build

%install
%python3_install
install -d %buildroot%_liconsdir/
rsvg-convert -w 48 -h 48  \
%buildroot%_iconsdir/hicolor/scalable/apps/%name.svg \
  -o %buildroot%_liconsdir/%name.png

%files
%doc README.md
%_bindir/%name
%python3_sitelibdir_noarch/*
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_liconsdir/%name.png
%_man1dir/*

%changelog
