Name: frozen-bubble
Version: 2.2.0
Release: alt3.1.1

Summary: Frozen Bubble arcade game
License: GPL
Group: Games/Arcade

URL: http://www.frozen-bubble.org/
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: %name-data = %version

# Automatically added by buildreq on Sun Oct 16 2011 (-bi)
BuildRequires: libSDL_mixer-devel libSDL_pango-devel perl-Locale-gettext perl-Math-Complex perl-SDL perl-devel

%description
Colorful 3D rendered penguin animations, 100 levels of 1p game,
hours and hours of 2p game, nights and nights of 2p/3p/4p/5p game
over LAN or Internet, a level-editor, 3 professional quality
digital soundtracks, 15 stereo sound effects, 8 unique graphical
transition effects, 8 unique logo eye-candies.

%prep
%setup -q
%patch -p1

%build
cd c_stuff
%perl_vendor_build MAKEFILE=Makefile

%install
mkdir -p %buildroot%_bindir
install -p -m755 %name %name-editor %buildroot%_bindir

mkdir -p %buildroot%_man6dir
install -p -m644 doc/%name.6 doc/%name-editor.6 %buildroot%_man6dir

mkdir -p %buildroot%_datadir/%name
cp -a data gfx snd %buildroot%_datadir/%name

mkdir -p %buildroot%_desktopdir
cat <<EOF >%buildroot%_desktopdir/%name.desktop
[Desktop Entry]
Version=2.0.0
Type=Application
Encoding=UTF-8
Name=Frozen Bubble
TryExec=frozen-bubble
Exec=frozen-bubble
Categories=Application;Game;ArcadeGame
Icon=/usr/share/icons/hicolor/48x48/apps/frozen-bubble.png
Comment=Frozen Bubble Arcade Game
EOF

install -pD -m644 icons/%name-icon-16x16.png %buildroot%_miconsdir/%name.png
install -pD -m644 icons/%name-icon-32x32.png %buildroot%_niconsdir/%name.png
install -pD -m644 icons/%name-icon-48x48.png %buildroot%_liconsdir/%name.png

cd c_stuff
%perl_vendor_install

%files
%doc README AUTHORS TIPS NEWS
%_bindir/%name
%_bindir/%name-editor
%_man6dir/%name.6*
%_man6dir/%name-editor.6*
%_desktopdir/%name.desktop
%_niconsdir/*.png
%_miconsdir/*.png
%_liconsdir/*.png
%perl_vendor_archlib/*.pm
%perl_vendor_autolib/fb_c_stuff

%package data
Summary: Frozen Bubble arcade game
Group: Games/Arcade
Conflicts: %name < %version
BuildArch: noarch

%description data
Colorful 3D rendered penguin animations, 100 levels of 1p game,
hours and hours of 2p game, nights and nights of 2p/3p/4p/5p game
over LAN or Internet, a level-editor, 3 professional quality
digital soundtracks, 15 stereo sound effects, 8 unique graphical
transition effects, 8 unique logo eye-candies.

%files data
%dir %_datadir/%name
%_datadir/%name/data
%_datadir/%name/gfx
%_datadir/%name/snd

# TODO:
# - package server
# - package locales

%changelog
