%define branch_point alt0
%define branch M80P
%define revision 1

Summary: Filesystem Archiver for Linux
Summary(ru_RU.UTF-8): Архиватор файловых систем

Name: fsarchiver
Version: 0.8.1
Release: %branch_point.%branch.%revision

Url: https://github.com/fdupoux/fsarchiver
Packager: Hihin Ruslan <ruslandh@altlinux.ru>

Epoch: 1

Source: %name-%version.tar
#Patch: cppcheck.patch

License: GPLv2+
Group: Archiving/Backup

# Automatically added by buildreq on Tue Nov 29 2011
# optimized out: libcom_err-devel libgpg-error libgpg-error-devel pkg-config
BuildRequires: bzlib-devel libattr-devel libblkid-devel libe2fs-devel libgcrypt-devel
BuildRequires: liblzma-devel liblzo2-devel libparted-devel libuuid-devel zlib-devel

%description
FSArchiver is a system tool that allows you to save the contents of
a file-system to a compressed archive file. The file-system can be
restored on a partition which has a different size and it can be
restored on a different file-system.

The following features have already been implemented in the current version:

-Support for basic file attributes (permissions, owner, ...)
-Support for multiple file-systems per archive
-Support for extended attributes (they are used by SELinux)
-Support the basic file-system attributes (label, uuid, block-size) for all
 linux file-systems
-Support for ntfs filesystems (ability to create flexible clones of
 windows partitions)
-Checksumming of everything which is written in the archive
 (headers, data blocks, whole files)
-Ability to restore an archive which is corrupt (it will just skip the
 current file)
-Multi-threaded lzo, gzip, bzip2, lzma compression: if you have a
 dual-core / quad-core it will use all the power of your cpu
-Lzma compression (slow but very efficient algorithm) to make your
 archive smaller.
-Support for splitting large archives into several files with a fixed
 maximum size
-Encryption of the archive using a password. Based on blowfish from libcrypto
 from openssl.

%description -l ru_RU.UTF8
FSArchiver  - системная утилита, позволяющая сохранить содержимое
файловых систем в виде сжатого файла. Файловые системы могут быть
восстановлены в разделы диска, отличающиеся от исходного размером и
типом файловой системы.

FSArchiver предоставляет следующие возможности:

- сохранение атрибутов файлов;
- включение в архив нескольких файловых систем;
- сохранение атрибутов файловой системы (label, uuid, размер блока);
- поддержку атрибутов файловой системы ntfs;
- создание контрольных сумм всего, что записано в архив;
- восстановление повреждённых архивов;
- много-поточное сжатие на нескольких процессорах в различные форматы (lzo, gzip, bzip, lzma);
- максимальное сжатие с помощью lzma (более медленный, но очень эффективный алгоритм);
- разделение архива на несколько файлов заданного размера;
- шифрование архива паролем на основе blowfish, libcrypto, openssl.

%prep
%setup
#patch -p2

%build
%autoreconf
%configure

%make_build

%install
%makeinstall_std

%files
%doc COPYING ChangeLog AUTHORS README
#config %_sysconfdir/%name.conf
%_sbindir/%name
%_man8dir/*

%changelog
