Name: fuse
Version: 2.9.7
Release: alt0.M80P.1

Summary: a tool for creating virtual filesystems
License: GPL
Group: System/Kernel and hardware

Url: https://github.com/libfuse/

Source: %name-%version.tar
Source1: fusermount-control
Source2: fuserumount

Patch0: %name.Makefile.patch
Patch1: %name.udev.patch
Patch2: %name.link.patch

Packager: Denis Smirnov <mithraen@altlinux.ru>

Requires: mount >= 2.11
Provides: avfs-fuse = %version
Obsoletes: avfs-fuse < %version

%description
FUSE (Filesystem in USErspace), an excellent tool
for creating custom filesystems with minimal effort
as well as for using them.

%package -n lib%name
Group: System/Kernel and hardware
Summary: tool for creating virtual filesystems
Requires: %name = %version-%release
Provides: FUSE = %version avfs-fuse = %version libavfs-fuse = %version
Obsoletes: FUSE < %version avfs-fuse < %version libavfs-fuse < %version

%description -n lib%name
FUSE (Filesystem in USErspace), an excellent tool
for creating custom filesystems with minimal effort.

This package contains shared libraries.

%package -n lib%name-devel
Group: System/Kernel and hardware
Summary: tool for creating virtual filesystems
Requires: lib%name = %version-%release
Provides: libavfs-fuse-devel = %version
Obsoletes: libavfs-fuse-devel < %version

%description -n lib%name-devel
FUSE (Filesystem in USErspace), an excellent tool
for creating custom filesystems with minimal effort.

This package contains development headers.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p0

%build
%autoreconf
%configure \
	--enable-lib \
	--enable-util \
	--disable-static
%make_build

%install
%makeinstall_std

mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/lib%name.so.* %buildroot/%_lib/
ln -sf ../../%_lib/lib%name.so.%version %buildroot%_libdir/lib%name.so

install -pD %SOURCE1 %buildroot%_sysconfdir/control.d/facilities/fusermount
rm -fr %buildroot%_sysconfdir/init.d

# sysconf/udev policy - /etc is for user
mkdir -p %buildroot%_udevrulesdir/
mv %buildroot%_sysconfdir/udev/rules.d/* %buildroot%_udevrulesdir/

install -pD %SOURCE2 %buildroot%_bindir/fuserumount

%pre
%_sbindir/groupadd -r -f fuse
%_sbindir/groupadd -r -f cuse
%pre_control fusermount

%post
%post_control -s fuseonly fusermount

%files
%doc AUTHORS NEWS README.md README.NFS doc/how-fuse-works doc/kernel.txt doc/html
%_sysconfdir/control.d/facilities/fusermount
%_udevrulesdir/*
/sbin/mount.fuse
%attr(4710,root,fuse) %_bindir/fusermount
%_bindir/ulockmgr_server
%attr(0755,root,root) %_bindir/fuserumount
%_man1dir/*
%_man8dir/*

%files -n lib%name
/%_lib/lib%name.so.*
%_libdir/lib*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%changelog
