%set_automake_version 1.10
%set_autoconf_version 2.60

Name: fuse-encfs
Summary: Encrypted pass-thru filesystem for Linux
Version: 1.7.4
Release: alt1.qa8
License: GPL
Group: System/Kernel and hardware
Packager: Denis Smirnov <mithraen@altlinux.ru>

Source: %name.tar
Url: http://pobox.com/~vgough/encfs

Patch1: encfs.link.patch
Patch2: encfs.static.char.patch
Patch3: 0001-boost-serialization-version-workaround.patch

# Automatically added by buildreq on Sun Feb 03 2008
BuildRequires: boost-devel gcc-c++ libattr-devel libfuse-devel libssl-devel librlog14-devel

BuildRequires: cvs

BuildRequires: libfuse-devel >= 2.1
BuildRequires: boost-devel boost-filesystem-devel

Requires: fuse
Requires: libssl >= 0.7.9g

Provides: encfs
Obsoletes: encfs

%description
EncFS implements an encrypted filesystem in userspace using FUSE.  FUSE
provides a Linux kernel module which allows virtual filesystems to be written
in userspace.  EncFS encrypts all data and filenames in the filesystem and
passes access through to the underlying filesystem.  Similar to CFS except that
it does not use NFS.

%prep
%setup -c %name-%version
## applied in upstream
#patch1 -p1
#patch2 -p2
## do we need it anymore???
#patch3 -p2

%build
CFLAGS="$CFLAGS -g -D_FILE_OFFSET_BITS=64"
export CFLAGS
%autoreconf
%configure \
    --enable-debug=no \
    --with-boost-system=boost_system-mt \
    --with-boost-filesystem=boost_filesystem-mt \
    --with-boost-serialization=boost_serialization-mt
%make_build SED=%_bindir/sed

# Testing for correct build
encfs/test

%install
%makeinstall_std
%find_lang encfs

%files -f encfs.lang
%_bindir/*
%_man1dir/*
%_libdir/*.so.*
%exclude %_libdir/*.so

%changelog
